/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModifierTagHolder {
    private final ItemStack itemStack;
    private final NBTTagList tagList;
    private final int index;
    public final NBTTagCompound tag;
    private ModifierNBT modifierNBT;

    private ModifierTagHolder(ItemStack itemStack, String modifier) {
        this.itemStack = itemStack;
        this.tagList = TagUtil.getModifiersTagList(itemStack);
        this.index = TinkerUtil.getIndexInCompoundList(this.tagList, modifier);
        this.tag = this.tagList.func_150305_b(this.index);
    }

    public <T extends ModifierNBT> T getTagData(Class<T> clazz) {
        T data = ModifierNBT.readTag(this.tag, clazz);
        this.modifierNBT = data;
        return data;
    }

    public void save() {
        if (this.modifierNBT != null) {
            this.modifierNBT.write(this.tag);
        }
        this.tagList.func_150304_a(this.index, (NBTBase)this.tag);
        TagUtil.setModifiersTagList(this.itemStack, this.tagList);
    }

    public static ModifierTagHolder getModifier(ItemStack itemStack, String modifier) {
        return new ModifierTagHolder(itemStack, modifier);
    }
}

