/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.utils;

import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import tk.zeitheron.solarflux.utils.IVariableHandler;

public class InventoryDummy
implements IInventory,
Iterable<ItemStack> {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private final int[] allSlots;
    public int inventoryStackLimit = 64;
    public BiPredicate<Integer, ItemStack> validSlots;
    public Runnable markedDirty;
    public Consumer<EntityPlayer> openInv;
    public Consumer<EntityPlayer> closeInv;
    public IVariableHandler fields;

    public InventoryDummy(int inventorySize, NBTTagCompound boundNBT) {
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.allSlots = new int[this.inventory.size()];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public InventoryDummy(NBTTagCompound boundNBT, ItemStack ... items) {
        int i;
        this.inventory = NonNullList.func_191197_a((int)items.length, (Object)ItemStack.field_190927_a);
        for (i = 0; i < items.length; ++i) {
            this.inventory.set(i, (Object)items[i]);
        }
        this.allSlots = new int[items.length];
        for (i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public InventoryDummy(int inventorySize) {
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.allSlots = new int[inventorySize];
        for (int i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public InventoryDummy(ItemStack ... items) {
        int i;
        this.inventory = NonNullList.func_191197_a((int)items.length, (Object)ItemStack.field_190927_a);
        for (i = 0; i < items.length; ++i) {
            this.inventory.set(i, (Object)items[i]);
        }
        this.allSlots = new int[items.length];
        for (i = 0; i < this.allSlots.length; ++i) {
            this.allSlots[i] = i;
        }
    }

    public int[] getAllAvaliableSlots() {
        return this.allSlots;
    }

    public String func_70005_c_() {
        return "Dummy Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        try {
            return (ItemStack)this.inventory.get(index);
        }
        catch (Throwable throwable) {
            return ItemStack.field_190927_a;
        }
    }

    public ItemStack func_70298_a(int slot, int count) {
        try {
            if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
                if (((ItemStack)this.inventory.get(slot)).func_190916_E() <= count) {
                    ItemStack is = (ItemStack)this.inventory.get(slot);
                    this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                    return is;
                }
                ItemStack is = ((ItemStack)this.inventory.get(slot)).func_77979_a(count);
                if (((ItemStack)this.inventory.get(slot)).func_190916_E() == 0) {
                    this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                }
                return is;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        try {
            this.inventory.set(index, (Object)stack);
            if (((ItemStack)this.inventory.get(index)).func_190916_E() > Math.min(((ItemStack)this.inventory.get(index)).func_77976_d(), this.func_70297_j_())) {
                ((ItemStack)this.inventory.get(index)).func_190920_e(Math.min(((ItemStack)this.inventory.get(index)).func_77976_d(), this.func_70297_j_()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int func_70297_j_() {
        return this.inventoryStackLimit;
    }

    public void func_70296_d() {
        if (this.markedDirty != null) {
            this.markedDirty.run();
        }
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.openInv != null) {
            this.openInv.accept(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.closeInv != null) {
            this.closeInv.accept(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.validSlots.test(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.inventory);
        }
        return nbt;
    }

    public InventoryDummy readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.inventory = NonNullList.func_191197_a((int)this.inventory.size(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
        }
        return this;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack s = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return s;
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public boolean isUsableByPlayer(EntityPlayer player, BlockPos from) {
        return player.func_174818_b(from) <= 64.0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void drop(World world, BlockPos pos) {
        InventoryDummy.drop(this, world, pos);
    }

    public static void drop(IInventory inv, World world, BlockPos pos) {
        if (inv == null || world == null || pos == null) {
            return;
        }
        if (!world.field_72995_K) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (s.func_190926_b()) continue;
                EntityItem drop = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, s);
                world.func_72838_d((Entity)drop);
                drop.func_174868_q();
            }
        }
        inv.func_174888_l();
    }

    public void writeToNBT(NBTTagCompound tag, String key) {
        tag.func_74782_a(key, (NBTBase)this.writeToNBT(new NBTTagCompound()));
    }

    public void readFromNBT(NBTTagCompound tag, String key) {
        this.readFromNBT(tag.func_74775_l(key));
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.inventory.iterator();
    }

    public Stream<ItemStack> stream() {
        return this.inventory.stream();
    }
}

