/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.Locale;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import tk.zeitheron.solarflux.api.SolarFluxAPI;
import tk.zeitheron.solarflux.api.SolarInfo;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.solarflux.init.SolarsSF;

@SideOnly(value=Side.CLIENT)
public class SolarFluxResourcePack
implements IResourcePack,
IResourceManagerReloadListener {
    public final Map<ResourceLocation, IResourceStreamSupplier> resourceMap = new HashMap<ResourceLocation, IResourceStreamSupplier>();
    public final Map<String, List<String>> langs = new HashMap<String, List<String>>();
    public final List<SolarInfo> infos = new ArrayList<SolarInfo>();
    public final Set<String> domains = new HashSet<String>();
    boolean calling = false;

    private static IResourceStreamSupplier ofText(String text) {
        return IResourceStreamSupplier.create(() -> true, () -> new ByteArrayInputStream(text.getBytes()));
    }

    private static IResourceStreamSupplier ofFile(Supplier<File> file) {
        return IResourceStreamSupplier.create(() -> ((File)file.get()).isFile(), () -> new FileInputStream((File)file.get()));
    }

    public void addPanel(SolarInfo si) {
        BlockBaseSolar blk = si.getBlock();
        ResourceLocation reg = blk.getRegistryName();
        ResourceLocation blockstate = new ResourceLocation(reg.func_110624_b(), "blockstates/" + reg.func_110623_a() + ".json");
        ResourceLocation models_block = new ResourceLocation(reg.func_110624_b(), "models/" + reg.func_110623_a() + ".json");
        ResourceLocation models_item = new ResourceLocation(reg.func_110624_b(), "models/item/" + reg.func_110623_a() + ".json");
        float thicc = si.height * 16.0f;
        float thic2 = thicc + 0.25f;
        float reverseThicc = 16.0f - thicc;
        this.resourceMap.put(blockstate, SolarFluxResourcePack.ofText("{\"variants\":{\"normal\":{\"model\":\"" + reg.func_110624_b() + ":block/" + reg.func_110623_a() + "\"}}}"));
        this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"" + reg.func_110624_b() + ":" + reg.func_110623_a() + "\"}"));
        this.resourceMap.put(models_block, SolarFluxResourcePack.ofText("{\"parent\":\"block/block\",\"textures\":{\"0\":\"" + reg.func_110624_b() + ":blocks/" + reg.func_110623_a() + "_base\",\"1\":\"" + reg.func_110624_b() + ":blocks/" + reg.func_110623_a() + "_top\",\"particle\":\"solarflux:blocks/example_base\"},\"elements\":[{\"name\":\"base\",\"from\":[0,0,0],\"to\":[16," + thicc + ",16],\"faces\":{\"north\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"east\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"south\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"west\":{\"uv\":[0," + reverseThicc + ",16,16],\"texture\":\"#0\"},\"up\":{\"uv\":[0,0,16,16],\"texture\":\"#1\"},\"down\":{\"uv\":[0,0,16,16],\"texture\":\"#0\"}}},{\"from\":[0," + thicc + ",0],\"to\":[16," + thic2 + ",1],\"faces\":{\"north\":{\"uv\":[0,0,16,0.25],\"texture\":\"#0\"},\"east\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,0,16,0.25],\"texture\":\"#0\"},\"west\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"up\":{\"uv\":[0,0,16,1],\"texture\":\"#0\"},\"down\":{\"uv\":[0,0,16,1],\"texture\":\"#0\"}}},{\"from\":[0," + thicc + ",15],\"to\":[16," + thic2 + ",16],\"faces\":{\"north\":{\"uv\":[0,15,16,15.25],\"texture\":\"#0\"},\"east\":{\"uv\":[0,15,1,15.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,15,16,15.25],\"texture\":\"#0\"},\"west\":{\"uv\":[0,15,1,15.25],\"texture\":\"#0\"},\"up\":{\"uv\":[0,15,16,16],\"texture\":\"#0\"},\"down\":{\"uv\":[0,15,16,16],\"texture\":\"#0\"}}},{\"from\":[0," + thicc + ",1],\"to\":[1," + thic2 + ",15],\"faces\":{\"north\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"east\":{\"uv\":[0,0,14,0.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,0,1,0.25],\"texture\":\"#0\"},\"west\":{\"uv\":[1,0,15,0.25],\"texture\":\"#0\"},\"up\":{\"uv\":[0,1,1,15],\"texture\":\"#0\"},\"down\":{\"uv\":[0,1,1,15],\"texture\":\"#0\"}}},{\"from\":[15," + thicc + ",1],\"to\":[16," + thic2 + ",15],\"faces\":{\"north\":{\"uv\":[15,15,16,15.25],\"texture\":\"#0\"},\"east\":{\"uv\":[1,15,15,15.25],\"texture\":\"#0\"},\"south\":{\"uv\":[0,15,1,15.25],\"texture\":\"#0\"},\"west\":{\"uv\":[1,15,15,15.25],\"texture\":\"#0\"},\"up\":{\"uv\":[15,1,16,15],\"texture\":\"#0\"},\"down\":{\"uv\":[15,1,16,15],\"texture\":\"#0\"}}}]}"));
        if (si.isCustom) {
            ResourceLocation textures_blocks_base = new ResourceLocation(reg.func_110624_b(), "textures/blocks/" + reg.func_110623_a() + "_base.png");
            ResourceLocation textures_blocks_top = new ResourceLocation(reg.func_110624_b(), "textures/blocks/" + reg.func_110623_a() + "_top.png");
            ResourceLocation textures_blocks_base_mcmeta = new ResourceLocation(reg.func_110624_b(), "textures/blocks/" + reg.func_110623_a() + "_base.png.mcmeta");
            ResourceLocation textures_blocks_top_mcmeta = new ResourceLocation(reg.func_110624_b(), "textures/blocks/" + reg.func_110623_a() + "_top.png.mcmeta");
            String n = reg.func_110623_a().startsWith("custom_solar_panel_") ? reg.func_110623_a().substring(19) : reg.func_110623_a().substring(12);
            this.resourceMap.put(textures_blocks_base, SolarFluxResourcePack.ofFile(() -> new File(new File(SolarsSF.getConfigDir(), "textures"), n + "_base.png")));
            this.resourceMap.put(textures_blocks_base_mcmeta, SolarFluxResourcePack.ofFile(() -> new File(new File(SolarsSF.getConfigDir(), "textures"), n + "_base.mcmeta")));
            this.resourceMap.put(textures_blocks_top, SolarFluxResourcePack.ofFile(() -> new File(new File(SolarsSF.getConfigDir(), "textures"), n + "_top.png")));
            this.resourceMap.put(textures_blocks_top_mcmeta, SolarFluxResourcePack.ofFile(() -> new File(new File(SolarsSF.getConfigDir(), "textures"), n + "_top.mcmeta")));
        }
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (this.calling) {
            return null;
        }
        this.calling = true;
        try {
            InputStream in = this.resourceMap.get(location).create();
            this.calling = false;
            return in;
        }
        catch (RuntimeException e) {
            this.calling = false;
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public boolean func_110589_b(ResourceLocation location) {
        IResourceStreamSupplier s = this.resourceMap.get(location);
        return s != null && s.exists();
    }

    public Set<String> func_110587_b() {
        return this.domains;
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return SolarFluxResourcePack.readMetadata(metadataSerializer, new ByteArrayInputStream("{\"pack\": {\"pack_format\": 1,\"description\": \"External & Generated resources for SolarFluxReborn\"}}".getBytes()), metadataSectionName);
    }

    static <T extends IMetadataSection> T readMetadata(MetadataSerializer metadataSerializer, InputStream p_110596_1_, String sectionName) {
        JsonObject jsonobject = null;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(p_110596_1_, StandardCharsets.UTF_8));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (RuntimeException runtimeexception) {
            try {
                throw new JsonParseException((Throwable)runtimeexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedreader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return (T)metadataSerializer.func_110503_a(sectionName, jsonobject);
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "SolarFluxReborn Builtin";
    }

    public void func_110549_a(IResourceManager resourceManager) {
        SolarFluxResourcePack.injectSolarPanelLanguages();
    }

    public static void injectSolarPanelLanguages() {
        if (SolarFluxAPI.SOLAR_PANELS == null) {
            return;
        }
        Field i18nLocalef = I18n.class.getDeclaredFields()[0];
        i18nLocalef.setAccessible(true);
        try {
            Locale locale = (Locale)Locale.class.cast(i18nLocalef.get(null));
            Field propertiesf = Locale.class.getDeclaredFields()[2];
            propertiesf.setAccessible(true);
            Map properties = (Map)Map.class.cast(propertiesf.get(locale));
            String code = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            HashMap langs = new HashMap();
            for (SolarInfo si : SolarFluxAPI.SOLAR_PANELS.getValuesCollection()) {
                if (si.localizations == null) continue;
                for (String lang : si.localizations.keySet()) {
                    String v;
                    ArrayList<String> ls = (ArrayList<String>)langs.get(lang);
                    if (ls == null) {
                        ls = new ArrayList<String>();
                        langs.put(lang, ls);
                    }
                    if (ls.contains(v = si.localizations.get(lang))) continue;
                    ls.add(si.getBlock().func_149739_a() + ".name=" + v);
                }
                if (si.localizations.containsKey("en_us")) {
                    properties.put(si.getBlock().func_149739_a() + ".name", si.localizations.get("en_us"));
                }
                if (!si.localizations.containsKey(code)) continue;
                properties.put(si.getBlock().func_149739_a() + ".name", si.localizations.get(code));
            }
            if (langs.containsKey(code)) {
                StringBuilder sb = new StringBuilder("# Builtin & Generated by Solar Flux Reborn lang file.\n");
                ((List)langs.get(code)).stream().map(ln -> "\n" + ln).forEach(sb::append);
                LanguageMap.inject((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
            }
        }
        catch (ReflectiveOperationException err) {
            err.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface IIOSupplier<T> {
        public T get() throws IOException;
    }

    public static interface IResourceStreamSupplier {
        public static IResourceStreamSupplier create(final BooleanSupplier exists, final IIOSupplier<InputStream> streamable) {
            return new IResourceStreamSupplier(){

                @Override
                public boolean exists() {
                    return exists.getAsBoolean();
                }

                @Override
                public InputStream create() throws IOException {
                    return (InputStream)streamable.get();
                }
            };
        }

        public boolean exists();

        public InputStream create() throws IOException;
    }
}

