/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world.dimension;

import aroma1997.core.log.LogHelper;
import aroma1997.core.misc.TeleporterNormal;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import aroma1997.core.util.WorldUtil;
import aroma1997.world.Config;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.item.BlockMiningPortal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TeleporterMining
extends Teleporter {
    public static final int SEARCH_RADIUS = (Integer)Util.ident((Object)32);

    public TeleporterMining(WorldServer world) {
        super(world);
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        entity.field_70145_X = true;
        if (!this.func_180620_b(entity, rotationYaw)) {
            this.func_85188_a(entity);
            if (!this.func_180620_b(entity, rotationYaw)) {
                new TeleporterNormal().placeEntity((World)this.field_85192_a, entity, rotationYaw);
            }
        }
        if (!Config.INSTANCE.welcomeMessage.trim().isEmpty() && this.field_85192_a.field_73011_w.getDimension() == Config.INSTANCE.dimensionid) {
            entity.func_145747_a(ServerUtil.getChatForString((String)Config.INSTANCE.welcomeMessage));
        }
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos entityPos = entity.func_180425_c();
        for (int xD = -SEARCH_RADIUS; xD <= SEARCH_RADIUS; ++xD) {
            for (int zD = -SEARCH_RADIUS; zD <= SEARCH_RADIUS; ++zD) {
                pos.func_181079_c(entityPos.func_177958_n() + xD, 0, entityPos.func_177952_p() + zD);
                for (int y = 1; y < 255; ++y) {
                    pos.func_185336_p(y);
                    IBlockState state = this.field_85192_a.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() != DimensionalWorldItems.miningPortal) continue;
                    int x = pos.func_177958_n();
                    int xN = pos.func_177958_n();
                    int xP = pos.func_177958_n();
                    int z = pos.func_177952_p();
                    int zN = pos.func_177952_p();
                    int zP = pos.func_177952_p();
                    while (this.field_85192_a.func_180495_p((BlockPos)pos).func_177230_c() == DimensionalWorldItems.miningPortal) {
                        pos.func_181079_c(--xN, pos.func_177956_o(), pos.func_177952_p());
                    }
                    pos.func_181079_c(x, y, z);
                    while (this.field_85192_a.func_180495_p((BlockPos)pos).func_177230_c() == DimensionalWorldItems.miningPortal) {
                        pos.func_181079_c(++xP, pos.func_177956_o(), pos.func_177952_p());
                    }
                    pos.func_181079_c(x, y, z);
                    while (this.field_85192_a.func_180495_p((BlockPos)pos).func_177230_c() == DimensionalWorldItems.miningPortal) {
                        pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), --zN);
                    }
                    pos.func_181079_c(x, y, z);
                    while (this.field_85192_a.func_180495_p((BlockPos)pos).func_177230_c() == DimensionalWorldItems.miningPortal) {
                        pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), ++zP);
                    }
                    pos.func_181079_c(pos.func_177958_n() + xD, y, pos.func_177952_p() + zD);
                    entity.func_70107_b((double)(xP + xN) / 2.0 + 0.5, (double)y + 0.15, (double)(zP + zN) / 2.0 + 0.5);
                    if (entity.field_70181_x < 0.0) {
                        entity.field_70181_x = 0.0;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected BlockMiningPortal.PortalSize getPortalSize(Entity e) {
        int counter = 0;
        HashSet<BlockPos> poses = new HashSet<BlockPos>();
        LinkedList<BlockPos> q = new LinkedList<BlockPos>();
        q.add(e.func_180425_c());
        while (!q.isEmpty()) {
            BlockPos currentPos = (BlockPos)q.poll();
            ++counter;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                BlockPos targetPos = currentPos.func_177972_a(side);
                if (poses.contains(targetPos)) continue;
                if (e.field_70170_p.func_180495_p(targetPos).func_177230_c() == DimensionalWorldItems.miningPortal) {
                    return BlockMiningPortal.PortalSize.getFirstValidPortralSize(e.field_70170_p, targetPos);
                }
                poses.add(targetPos);
                q.add(targetPos);
            }
            if (counter <= 30) continue;
            break;
        }
        return null;
    }

    public Iterable<EnumFacing> getFacing(EnumFacing.Axis axis, boolean onlyOnce) {
        if (axis == EnumFacing.Axis.Y) {
            axis = null;
        }
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
        if (!onlyOnce) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (facing.func_176740_k() != axis && axis != null) continue;
                facings.add(facing);
            }
            return facings;
        }
        HashSet<EnumFacing.Axis> alreadyAdded = new HashSet<EnumFacing.Axis>();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (facing.func_176740_k() != axis && axis != null || alreadyAdded.contains(facing.func_176740_k())) continue;
            facings.add(facing);
            alreadyAdded.add(facing.func_176740_k());
        }
        return facings;
    }

    public boolean func_85188_a(Entity entity) {
        int up;
        int side;
        int currentY;
        double entityDisplacementZ;
        double entityDisplacementX;
        int currentX;
        EnumFacing right;
        BlockMiningPortal.PortalSize size = this.getPortalSize(entity);
        int height = 3;
        int width = 2;
        EnumFacing top = EnumFacing.UP;
        EnumFacing enumFacing = right = entity.field_70170_p.field_73012_v.nextBoolean() ? EnumFacing.NORTH : EnumFacing.EAST;
        if (size != null && size.isValid()) {
            height = size.getHeight();
            width = size.getWidth();
            right = size.rightDir;
            top = size.upDir;
        }
        height += 2;
        width += 2;
        EnumFacing back = WorldUtil.rotateAround((EnumFacing)right, (EnumFacing)top);
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        int bestFoundPosX = x;
        int bestFoundPosY = y;
        int bestFoundPosZ = z;
        double bestFoundEntityDisplacementSq = -1.0;
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (currentX = x - SEARCH_RADIUS; currentX <= x + SEARCH_RADIUS; ++currentX) {
            entityDisplacementX = (double)currentX + 0.5 - entity.field_70165_t;
            for (int l2 = z - SEARCH_RADIUS; l2 <= z + SEARCH_RADIUS; ++l2) {
                entityDisplacementZ = (double)l2 + 0.5 - entity.field_70161_v;
                block2: for (currentY = this.field_85192_a.func_72940_L() - 1; currentY >= 0; --currentY) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)currentPos.func_181079_c(currentX, currentY, l2))) continue;
                    while (currentY > 0 && this.field_85192_a.func_175623_d((BlockPos)currentPos.func_181079_c(currentX, currentY - 1, l2))) {
                        --currentY;
                    }
                    for (int searchFront = 0; searchFront < 3; ++searchFront) {
                        for (int searchSide = 0; searchSide < width; ++searchSide) {
                            for (int searchUp = -1; searchUp < height - 1; ++searchUp) {
                                int currentPosX = currentX + (searchSide - 1) * right.func_82601_c() + searchFront * back.func_82601_c();
                                int currentPosY = currentY + searchUp;
                                int currentPosZ = l2 + (searchSide - 1) * right.func_82599_e() + searchFront * back.func_82599_e();
                                currentPos.func_181079_c(currentPosX, currentPosY, currentPosZ);
                                if (searchUp < 0 && !this.field_85192_a.func_180495_p((BlockPos)currentPos).func_185904_a().func_76220_a() || searchUp >= 0 && !this.field_85192_a.func_175623_d((BlockPos)currentPos)) continue block2;
                            }
                        }
                    }
                    double entityDisplacementY = (double)currentY + 0.5 - entity.field_70163_u;
                    double entityDisplacementSq = entityDisplacementX * entityDisplacementX + entityDisplacementY * entityDisplacementY + entityDisplacementZ * entityDisplacementZ;
                    if (!(bestFoundEntityDisplacementSq < 0.0) && !(entityDisplacementSq < bestFoundEntityDisplacementSq)) continue;
                    bestFoundEntityDisplacementSq = entityDisplacementSq;
                    bestFoundPosX = currentX;
                    bestFoundPosY = currentY;
                    bestFoundPosZ = l2;
                }
            }
        }
        if (bestFoundEntityDisplacementSq < 0.0) {
            for (currentX = x - SEARCH_RADIUS; currentX <= x + SEARCH_RADIUS; ++currentX) {
                entityDisplacementX = (double)currentX + 0.5 - entity.field_70165_t;
                for (int currentZ = z - SEARCH_RADIUS; currentZ <= z + SEARCH_RADIUS; ++currentZ) {
                    entityDisplacementZ = (double)currentZ + 0.5 - entity.field_70161_v;
                    block9: for (currentY = this.field_85192_a.func_72940_L() - 1; currentY >= 0; --currentY) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)currentPos.func_181079_c(currentX, currentY, currentZ))) continue;
                        while (currentY > 0 && this.field_85192_a.func_175623_d((BlockPos)currentPos.func_181079_c(currentX, currentY - 1, currentZ))) {
                            --currentY;
                        }
                        for (int searchFront = 0; searchFront < width; ++searchFront) {
                            for (int searchTop = -1; searchTop < height - 1; ++searchTop) {
                                int j12 = currentX + (searchFront - 1) * right.func_82601_c();
                                int i13 = currentY + searchTop;
                                int j13 = currentZ + (searchFront - 1) * right.func_82599_e();
                                currentPos.func_181079_c(j12, i13, j13);
                                if (searchTop < 0 && !this.field_85192_a.func_180495_p((BlockPos)currentPos).func_185904_a().func_76220_a() || searchTop >= 0 && !this.field_85192_a.func_175623_d((BlockPos)currentPos)) continue block9;
                            }
                        }
                        double entityDisplacementY = (double)currentY + 0.5 - entity.field_70163_u;
                        double entityDisplacementSq = entityDisplacementX * entityDisplacementX + entityDisplacementY * entityDisplacementY + entityDisplacementZ * entityDisplacementZ;
                        if (!(bestFoundEntityDisplacementSq < 0.0) && !(entityDisplacementSq < bestFoundEntityDisplacementSq)) continue;
                        bestFoundEntityDisplacementSq = entityDisplacementSq;
                        bestFoundPosX = currentX;
                        bestFoundPosY = currentY;
                        bestFoundPosZ = currentZ;
                    }
                }
            }
        }
        IBlockState portalState = DimensionalWorldItems.miningPortal.func_176223_P().func_177226_a((IProperty)DimensionalWorldItems.miningPortal.property, (Comparable)size.getAxis());
        IBlockState portalFrameState = DimensionalWorldItems.portalFrame.func_176223_P();
        IBlockState airState = Blocks.field_150350_a.func_176223_P();
        BlockPos bottomLeftPos = new BlockPos(bestFoundPosX, bestFoundPosY, bestFoundPosZ);
        if (bestFoundEntityDisplacementSq < 0.0) {
            bottomLeftPos = new BlockPos(bottomLeftPos.func_177958_n(), MathHelper.func_76125_a((int)bestFoundPosY, (int)70, (int)(this.field_85192_a.func_72940_L() - 10)), bottomLeftPos.func_177952_p());
            if (top.func_176740_k() == EnumFacing.Axis.Y) {
                for (int front = -1; front <= 1; ++front) {
                    for (int side2 = 1; side2 < width - 1; ++side2) {
                        for (int up2 = -1; up2 < height - 2; ++up2) {
                            BlockPos currentBlockPos = bottomLeftPos.func_177967_a(back, front).func_177967_a(right, side2).func_177967_a(top, up2);
                            boolean placeFrame = up2 < 0;
                            this.field_85192_a.func_175656_a(currentBlockPos, placeFrame ? portalFrameState : airState);
                        }
                    }
                }
            }
        }
        for (side = 0; side < width; ++side) {
            for (up = -1; up < height - 1; ++up) {
                BlockPos currentBlockPos = bottomLeftPos.func_177967_a(right, side).func_177967_a(top, up);
                boolean placeFrame = side == 0 || side == width - 1 || up == -1 || up == height - 2;
                this.field_85192_a.func_180501_a(currentBlockPos, placeFrame ? portalFrameState : portalState, 2);
            }
        }
        for (side = 0; side < width; ++side) {
            for (up = -1; up < height; ++up) {
                BlockPos currentBlockPos = bottomLeftPos.func_177967_a(right, side).func_177967_a(top, up);
                this.field_85192_a.func_175685_c(currentBlockPos, this.field_85192_a.func_180495_p(currentBlockPos).func_177230_c(), false);
            }
        }
        LogHelper.debugLog((String)("Created portal at " + bottomLeftPos));
        return true;
    }
}

