/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.client;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.lang.Lang;
import gg.galaxygaming.gasconduits.client.utils.GasRenderUtil;
import gg.galaxygaming.gasconduits.common.filter.GasFilter;
import gg.galaxygaming.gasconduits.common.filter.IGasFilter;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextComponentTranslation;

public class GasFilterGui
extends AbstractFilterGui {
    private static final int ID_WHITELIST = FilterGuiUtil.nextButtonId();
    private final IconButton whiteListB;
    @Nonnull
    private final GasFilter filter;
    private int xOffset = 13;
    private int yOffset = 34;

    public GasFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IGasFilter filterIn) {
        super(playerInv, filterContainer, te, (IFilter)filterIn, new String[]{"gas_filter"});
        this.filter = (GasFilter)filterIn;
        this.whiteListB = new IconButton((IGuiScreen)this, ID_WHITELIST, this.xOffset + 98, this.yOffset + 1, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
    }

    public void initGui() {
        this.createFilterSlots();
        super.initGui();
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots((NNList<GhostSlot>)this.getGhostSlotHandler().getGhostSlots(), this.xOffset + 1, this.yOffset + 1, () -> ((GasFilterGui)this).sendFilterChange());
    }

    public void updateButtons() {
        super.updateButtons();
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        }
    }

    protected void actionPerformed(@Nonnull GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.field_146127_k == ID_WHITELIST) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        if (!this.filter.isEmpty()) {
            int x = this.getGuiLeft() + this.xOffset;
            int y = this.getGuiTop() + this.yOffset;
            for (int i = 0; i < this.filter.size(); ++i) {
                GasStack g = this.filter.getGasStackAt(i);
                if (g == null) continue;
                this.renderGas(g, x + i * 18, y);
            }
        }
    }

    private void renderGas(GasStack g, int x, int y) {
        if (g.getGas().getSprite() != null) {
            GasRenderUtil.renderGuiTank(g, 1000, 1000, x + 1, y + 1, 16.0, 16.0);
        }
    }

    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return new TextComponentTranslation("gasconduits.gui.gas_filter", new Object[0]).func_150261_e();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
        GasStack gas = this.getHoveredGas(mouseX, mouseY);
        if (gas != null) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(gas.getGas().getLocalizedName());
            this.drawHoveringToolTipText(tooltip, mouseX, mouseY, this.fontRenderer);
        }
    }

    private GasStack getHoveredGas(int mouseX, int mouseY) {
        int x;
        if (mouseY >= this.getGuiTop() + this.yOffset && mouseY <= this.getGuiTop() + this.yOffset + 16 && (x = mouseX - (this.getGuiLeft() + this.xOffset)) >= 0 && x % 18 != 17) {
            return this.filter.getGasStackAt(x / 18);
        }
        return null;
    }
}

