/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigTagParent;
import codechicken.lib.util.ArrayUtils;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.CommonUtils;
import codechicken.nei.ItemSorter;
import codechicken.nei.LayoutManager;
import codechicken.nei.api.API;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.NEIInfo;
import codechicken.nei.api.TaggedInventoryArea;
import codechicken.nei.config.ConfigSet;
import codechicken.nei.config.GuiNEIOptionList;
import codechicken.nei.config.GuiOptionList;
import codechicken.nei.config.OptionCycled;
import codechicken.nei.config.OptionGamemodes;
import codechicken.nei.config.OptionList;
import codechicken.nei.config.OptionTextField;
import codechicken.nei.config.OptionToggleButton;
import codechicken.nei.config.OptionUtilities;
import codechicken.nei.jei.EnumItemBrowser;
import codechicken.nei.jei.JEIIntegrationManager;
import codechicken.nei.jei.gui.ItemBrowserButton;
import codechicken.nei.layout.LayoutStyle;
import codechicken.nei.util.ItemStackSet;
import codechicken.nei.util.LogHelper;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.widget.SubsetWidget;
import codechicken.nei.widget.action.NEIActions;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSummary;
import org.apache.commons.io.FileUtils;

public class NEIClientConfig {
    private static boolean isEnabled;
    public static File configDir;
    public static ConfigSet global;
    public static ConfigSet world;
    public static ItemStack[] creativeInv;
    private static boolean[] statesSaved;
    public static boolean hasSMPCounterpart;
    public static HashSet<String> permissibleActions;
    public static HashSet<String> disabledActions;
    public static HashSet<String> enabledActions;
    public static ItemStackSet bannedItems;

    private static void setDefaults() {
        ConfigTagParent tag = NEIClientConfig.global.config;
        tag.setComment("Main configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        tag.getTag("command").useBraces().setComment("Change these options if you have a different mod installed on the server that handles the commands differently, Eg. Bukkit Essentials");
        tag.setNewLineMode(1);
        tag.getTag("inventory.widgetsenabled").getBooleanValue(true);
        API.addOption(new OptionToggleButton("inventory.widgetsenabled"));
        tag.getTag("inventory.hidden").getBooleanValue(false);
        tag.getTag("inventory.cheatmode").getIntValue(2);
        tag.getTag("inventory.lockmode").setComment("For those who can't help themselves.\nSet this to a mode and you will be unable to change it ingame").getIntValue(-1);
        API.addOption(new OptionCycled("inventory.cheatmode", 3){

            @Override
            public boolean optionValid(int index) {
                return NEIClientConfig.getLockedMode() == -1 || NEIClientConfig.getLockedMode() == index;
            }
        });
        NEIClientConfig.checkCheatMode();
        tag.getTag("inventory.utilities").setDefaultValue("delete, magnet");
        API.addOption(new OptionUtilities("inventory.utilities"));
        tag.getTag("inventory.gamemodes").setDefaultValue("creative, creative+, adventure");
        API.addOption(new OptionGamemodes("inventory.gamemodes"));
        tag.getTag("inventory.layoutstyle").getIntValue(0);
        API.addOption(new OptionCycled("inventory.layoutstyle", 0){

            @Override
            public String getPrefix() {
                return this.translateN(this.name, new Object[0]);
            }

            @Override
            public String getButtonText() {
                return NEIClientUtils.translate("layoutstyle." + LayoutManager.getLayoutStyle(this.renderTag().getIntValue()).getName(), new Object[0]);
            }

            @Override
            public boolean cycle() {
                LinkedList<Integer> list = new LinkedList<Integer>();
                for (Map.Entry<Integer, LayoutStyle> entry : LayoutManager.layoutStyles.entrySet()) {
                    list.add(entry.getKey());
                }
                Collections.sort(list);
                int nextLayout = this.renderTag().getIntValue();
                if (nextLayout == (Integer)list.getLast()) {
                    nextLayout = -1;
                }
                for (Integer i : list) {
                    if (i <= nextLayout) continue;
                    nextLayout = i;
                    break;
                }
                this.getTag().setIntValue(nextLayout);
                return true;
            }
        });
        ItemSorter.initConfig(tag);
        tag.getTag("inventory.itemIDs").getIntValue(1);
        API.addOption(new OptionCycled("inventory.itemIDs", 3, true));
        tag.getTag("inventory.searchmode").getIntValue(1);
        API.addOption(new OptionCycled("inventory.searchmode", 3, true));
        tag.getTag("inventory.profileRecipes").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.profileRecipes", true));
        tag.getTag("inventory.disableMouseScrollTransfer").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.disableMouseScrollTransfer", true));
        tag.getTag("inventory.invertMouseScrollTransfer").getBooleanValue(false);
        API.addOption(new OptionToggleButton("inventory.invertMouseScrollTransfer", true){

            @Override
            public boolean isEnabled() {
                return NEIClientConfig.isMouseScrollTransferEnabled();
            }
        });
        tag.getTag("command.creative").setDefaultValue("/gamemode {0} {1}");
        API.addOption(new OptionTextField("command.creative"));
        tag.getTag("command.item").setDefaultValue("/give {0} {1} {2} {3} {4}");
        API.addOption(new OptionTextField("command.item"));
        tag.getTag("command.time").setDefaultValue("/time set {0}");
        API.addOption(new OptionTextField("command.time"));
        tag.getTag("command.rain").setDefaultValue("/toggledownfall");
        API.addOption(new OptionTextField("command.rain"));
        tag.getTag("command.heal").setDefaultValue("");
        API.addOption(new OptionTextField("command.heal"));
        JEIIntegrationManager.initConfig(tag);
        API.addOption(new ItemBrowserButton("jei.itemPanel"){

            @Override
            protected void setValue(EnumItemBrowser itemBrowser) {
                JEIIntegrationManager.setItemPanelOwner(itemBrowser);
            }
        });
        API.addOption(new ItemBrowserButton("jei.searchBox"){

            @Override
            public boolean isEnabled() {
                return JEIIntegrationManager.itemPanelOwner == EnumItemBrowser.JEI;
            }

            @Override
            protected void setValue(EnumItemBrowser itemBrowser) {
                JEIIntegrationManager.setSearchBoxOwner(itemBrowser);
            }
        });
    }

    private static void linkOptionList() {
        OptionList.setOptionList(new OptionList("nei.options"){

            @Override
            public ConfigSet globalConfigSet() {
                return global;
            }

            @Override
            public ConfigSet worldConfigSet() {
                return world;
            }

            @Override
            public OptionList configBase() {
                return this;
            }

            @Override
            public GuiOptionList getGui(GuiScreen parent, OptionList list, boolean world) {
                return new GuiNEIOptionList(parent, list, world);
            }
        });
    }

    public static OptionList getOptionList() {
        return OptionList.getOptionList("nei.options");
    }

    public static void loadWorld(String saveName) {
        boolean newWorld;
        NEIClientConfig.setInternalEnabled(true);
        LogHelper.debug("Loading " + (Minecraft.func_71410_x().func_71356_B() ? "Local" : "Remote") + " World");
        File saveDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + saveName);
        boolean bl = newWorld = !saveDir.exists();
        if (newWorld) {
            saveDir.mkdirs();
        }
        world = new ConfigSet(new File(saveDir, "NEI.dat"), (ConfigTagParent)new ConfigFile(new File(saveDir, "NEI.cfg")));
        NEIClientConfig.onWorldLoad(newWorld);
    }

    private static void onWorldLoad(boolean newWorld) {
        NEIClientConfig.world.config.setComment("World based configuration of NEI.\nMost of these options can be changed ingame.\nDeleting any element will restore it to it's default value");
        NEIClientConfig.setWorldDefaults();
        creativeInv = new ItemStack[54];
        ArrayUtils.fillArray((Object[])creativeInv, (Object)ItemStack.field_190927_a);
        LayoutManager.searchField.setText(NEIClientConfig.getSearchExpression());
        LayoutManager.quantity.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
        SubsetWidget.loadHidden();
        if (newWorld && Minecraft.func_71410_x().func_71356_B()) {
            NEIClientConfig.world.config.getTag("inventory.cheatmode").setIntValue(Minecraft.func_71410_x().field_71442_b.func_78758_h() ? 2 : 0);
        }
        NEIInfo.load(ClientUtils.getWorld());
    }

    private static void setWorldDefaults() {
        NBTTagCompound nbt = NEIClientConfig.world.nbt;
        if (!nbt.func_74764_b("search")) {
            nbt.func_74778_a("search", "");
        }
        if (!nbt.func_74764_b("quantity")) {
            nbt.func_74768_a("quantity", 0);
        }
        if (!nbt.func_74764_b("validateenchantments")) {
            nbt.func_74757_a("validateenchantments", false);
        }
        world.saveNBT();
    }

    public static void loadStates() {
        for (int state = 0; state < 7; ++state) {
            NEIClientConfig.statesSaved[state] = !NEIClientConfig.global.nbt.func_74775_l("save" + state).func_82582_d();
        }
    }

    public static boolean isWorldSpecific(String setting) {
        if (world == null) {
            return false;
        }
        ConfigTag tag = NEIClientConfig.world.config.getTag(setting, false);
        return tag != null && tag.value != null;
    }

    public static boolean isStateSaved(int i) {
        return statesSaved[i];
    }

    public static ConfigTag getSetting(String s) {
        return NEIClientConfig.isWorldSpecific(s) ? NEIClientConfig.world.config.getTag(s) : NEIClientConfig.global.config.getTag(s);
    }

    public static boolean getBooleanSetting(String s) {
        return NEIClientConfig.getSetting(s).getBooleanValue();
    }

    public static boolean isHidden() {
        return !isEnabled || NEIClientConfig.getBooleanSetting("inventory.hidden");
    }

    public static boolean isEnabled() {
        return isEnabled && NEIClientConfig.getBooleanSetting("inventory.widgetsenabled");
    }

    public static void setEnabled(boolean flag) {
        NEIClientConfig.getSetting("inventory.widgetsenabled").setBooleanValue(flag);
    }

    public static int getItemQuantity() {
        return NEIClientConfig.world.nbt.func_74762_e("quantity");
    }

    public static int getCheatMode() {
        return NEIClientConfig.getIntSetting("inventory.cheatmode");
    }

    private static void checkCheatMode() {
        if (NEIClientConfig.getLockedMode() != -1) {
            NEIClientConfig.setIntSetting("inventory.cheatmode", NEIClientConfig.getLockedMode());
        }
    }

    public static int getLockedMode() {
        return NEIClientConfig.getIntSetting("inventory.lockmode");
    }

    public static int getLayoutStyle() {
        return NEIClientConfig.getIntSetting("inventory.layoutstyle");
    }

    public static String getStringSetting(String s) {
        return NEIClientConfig.getSetting(s).getValue();
    }

    public static boolean showIDs() {
        int i = NEIClientConfig.getIntSetting("inventory.itemIDs");
        return i == 2 || i == 1 && NEIClientConfig.isEnabled() && !NEIClientConfig.isHidden();
    }

    public static void toggleBooleanSetting(String setting) {
        ConfigTag tag;
        tag.setBooleanValue(!(tag = NEIClientConfig.getSetting(setting)).getBooleanValue());
    }

    public static void cycleSetting(String setting, int max) {
        ConfigTag tag = NEIClientConfig.getSetting(setting);
        tag.setIntValue((tag.getIntValue() + 1) % max);
    }

    public static int getIntSetting(String setting) {
        return NEIClientConfig.getSetting(setting).getIntValue();
    }

    public static void setIntSetting(String setting, int val) {
        NEIClientConfig.getSetting(setting).setIntValue(val);
    }

    public static String getSearchExpression() {
        return NEIClientConfig.world.nbt.func_74779_i("search");
    }

    public static void setSearchExpression(String expression) {
        JEIIntegrationManager.setFilterText(expression);
        NEIClientConfig.world.nbt.func_74778_a("search", expression);
        world.saveNBT();
    }

    public static void setSearchExpression(String expression, boolean updateJEI) {
        if (updateJEI) {
            NEIClientConfig.setSearchExpression(expression);
        } else {
            NEIClientConfig.world.nbt.func_74778_a("search", expression);
            world.saveNBT();
        }
    }

    public static boolean isMouseScrollTransferEnabled() {
        return !NEIClientConfig.getBooleanSetting("inventory.disableMouseScrollTransfer");
    }

    public static boolean shouldInvertMouseScrollTransfer() {
        return !NEIClientConfig.getBooleanSetting("inventory.invertMouseScrollTransfer");
    }

    public static boolean isMagnetModeEnabled() {
        return enabledActions.contains("magnet");
    }

    public static boolean invCreativeMode() {
        return enabledActions.contains("creative+") && NEIClientConfig.canPerformAction("creative+");
    }

    public static boolean areDamageVariantsShown() {
        return NEIClientConfig.hasSMPCounterPart() || NEIClientConfig.getSetting("command.item").getValue().contains("{3}");
    }

    public static void clearState(int state) {
        NEIClientConfig.statesSaved[state] = false;
        NEIClientConfig.global.nbt.func_74782_a("save" + state, (NBTBase)new NBTTagCompound());
        global.saveNBT();
    }

    public static void loadState(int state) {
        List<TaggedInventoryArea> areaList;
        if (!statesSaved[state]) {
            return;
        }
        NBTTagCompound statesave = NEIClientConfig.global.nbt.func_74775_l("save" + state);
        GuiContainer currentContainer = NEIClientUtils.getGuiContainer();
        LinkedList<TaggedInventoryArea> saveAreas = new LinkedList<TaggedInventoryArea>();
        saveAreas.add(new TaggedInventoryArea(Minecraft.func_71410_x().field_71439_g.field_71071_by));
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            areaList = handler.getInventoryAreas(currentContainer);
            if (areaList == null) continue;
            saveAreas.addAll(areaList);
        }
        for (TaggedInventoryArea area : saveAreas) {
            if (!statesave.func_74764_b(area.tagName)) continue;
            areaList = area.slots.iterator();
            while (areaList.hasNext()) {
                int slot = (Integer)areaList.next();
                NEIClientUtils.setSlotContents(slot, ItemStack.field_190927_a, area.isContainer());
            }
            NBTTagList areaTag = statesave.func_150295_c(area.tagName, 10);
            for (int i = 0; i < areaTag.func_74745_c(); ++i) {
                NBTTagCompound stacksave = areaTag.func_150305_b(i);
                int slot = stacksave.func_74771_c("Slot") & 0xFF;
                if (!area.slots.contains(slot)) continue;
                NEIClientUtils.setSlotContents(slot, new ItemStack(stacksave), area.isContainer());
            }
        }
    }

    public static void saveState(int state) {
        NBTTagCompound statesave = NEIClientConfig.global.nbt.func_74775_l("save" + state);
        GuiContainer currentContainer = NEIClientUtils.getGuiContainer();
        LinkedList<TaggedInventoryArea> saveAreas = new LinkedList<TaggedInventoryArea>();
        saveAreas.add(new TaggedInventoryArea(Minecraft.func_71410_x().field_71439_g.field_71071_by));
        for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
            List<TaggedInventoryArea> areaList = handler.getInventoryAreas(currentContainer);
            if (areaList == null) continue;
            saveAreas.addAll(areaList);
        }
        for (TaggedInventoryArea area : saveAreas) {
            NBTTagList areaTag = new NBTTagList();
            for (int i : area.slots) {
                ItemStack stack = area.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                NBTTagCompound stacksave = new NBTTagCompound();
                stacksave.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(stacksave);
                areaTag.func_74742_a((NBTBase)stacksave);
            }
            statesave.func_74782_a(area.tagName, (NBTBase)areaTag);
        }
        NEIClientConfig.global.nbt.func_74782_a("save" + state, (NBTBase)statesave);
        global.saveNBT();
        NEIClientConfig.statesSaved[state] = true;
    }

    public static boolean hasSMPCounterPart() {
        return hasSMPCounterpart;
    }

    public static void setHasSMPCounterPart(boolean flag) {
        hasSMPCounterpart = flag;
        permissibleActions.clear();
        bannedItems.clear();
        disabledActions.clear();
        enabledActions.clear();
    }

    public static boolean canCheatItem(ItemStack stack) {
        return NEIClientConfig.canPerformAction("item") && !bannedItems.contains(stack);
    }

    public static boolean canPerformAction(String name) {
        if (!NEIClientConfig.isEnabled()) {
            return false;
        }
        if (!NEIClientConfig.modePermitsAction(name)) {
            return false;
        }
        String base = NEIActions.base(name);
        if (hasSMPCounterpart) {
            return permissibleActions.contains(base);
        }
        if (NEIActions.smpRequired(name)) {
            return false;
        }
        String cmd = NEIClientConfig.getStringSetting("command." + base);
        return cmd != null && cmd.startsWith("/");
    }

    private static boolean modePermitsAction(String name) {
        String[] actions;
        if (NEIClientConfig.getCheatMode() == 0) {
            return false;
        }
        if (NEIClientConfig.getCheatMode() == 2) {
            return true;
        }
        for (String action : actions = NEIClientConfig.getStringArrSetting("inventory.utilities")) {
            if (!action.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String[] getStringArrSetting(String s) {
        return NEIClientConfig.getStringSetting(s).replace(" ", "").split(",");
    }

    public static void setInternalEnabled(boolean b) {
        isEnabled = b;
    }

    public static void reloadSaves() {
        List saves;
        File saveDir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/local");
        if (!saveDir.exists()) {
            return;
        }
        try {
            saves = Minecraft.func_71410_x().func_71359_d().func_75799_b();
        }
        catch (Exception e) {
            LogHelper.errorError("Error loading saves", e);
            return;
        }
        HashSet<String> saveFileNames = new HashSet<String>();
        for (WorldSummary save : saves) {
            saveFileNames.add(save.func_75786_a());
        }
        for (File file : saveDir.listFiles()) {
            if (!file.isDirectory() || saveFileNames.contains(file.getName())) continue;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete folder: " + file, e);
            }
        }
    }

    static {
        configDir = new File(CommonUtils.getMinecraftDir(), "config/NEI/");
        global = new ConfigSet(new File("saves/NEI/client.dat"), (ConfigTagParent)new ConfigFile(new File(configDir, "client.cfg")));
        statesSaved = new boolean[7];
        permissibleActions = new HashSet();
        disabledActions = new HashSet();
        enabledActions = new HashSet();
        bannedItems = new ItemStackSet();
        NEIClientConfig.linkOptionList();
        NEIClientConfig.setDefaults();
    }
}

