/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.MathUtil;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractMachineRecipe
implements IMachineRecipe {
    @Nonnull
    private static final IMachineRecipe.ResultStack[] EMPTY_RESULT = new IMachineRecipe.ResultStack[0];

    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return 0;
        }
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        return recipe == null ? 0 : recipe.getEnergyRequired();
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType(@Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return RecipeBonusType.NONE;
        }
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        if (recipe == null) {
            return RecipeBonusType.NONE;
        }
        return recipe.getBonusType();
    }

    public abstract IRecipe getRecipeForInputs(@Nonnull RecipeLevel var1, @Nonnull NNList<MachineRecipeInput> var2);

    @Nonnull
    public NNList<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        NNList result = new NNList();
        ArrayList<MachineRecipeInput> availableInputs = new ArrayList<MachineRecipeInput>();
        for (MachineRecipeInput available : inputs) {
            availableInputs.add(available.copy());
        }
        ArrayList<IRecipeInput> requiredIngredients = new ArrayList<IRecipeInput>();
        for (IRecipeInput ri : recipe.getInputs()) {
            requiredIngredients.add(ri.copy());
        }
        block2: for (IRecipeInput required : requiredIngredients) {
            for (MachineRecipeInput available : availableInputs) {
                if (required == null || available == null || !this.isValid(available) || !this.consume(required, available, (List<MachineRecipeInput>)result)) continue;
                continue block2;
            }
        }
        return result;
    }

    protected boolean consume(@Nonnull IRecipeInput required, @Nonnull MachineRecipeInput available, @Nonnull List<MachineRecipeInput> consumedInputs) {
        if (required.isInput(available.fluid)) {
            consumedInputs.add(new MachineRecipeInput(available.slotNumber, required.getFluidInput().copy()));
            return true;
        }
        if (required.isInput(available.item) && MathUtil.isAny(required.getSlotNumber(), -1, available.slotNumber)) {
            ItemStack availableStack = available.item;
            ItemStack consumedStack = availableStack.func_77946_l();
            consumedStack.func_190920_e(Math.min(required.getStackSize(), availableStack.func_190916_E()));
            required.shrinkStack(consumedStack.func_190916_E());
            availableStack.func_190918_g(consumedStack.func_190916_E());
            consumedInputs.add(new MachineRecipeInput(available.slotNumber, consumedStack));
            if (required.getStackSize() <= 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValid(@Nonnull MachineRecipeInput input) {
        return Prep.isValid(input.item) || input.fluid != null && input.fluid.amount > 0;
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return false;
        }
        return this.getRecipeForInputs(machineLevel, inputs) != null;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return EMPTY_RESULT;
        }
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        if (recipe == null) {
            return EMPTY_RESULT;
        }
        RecipeOutput[] outputs = recipe.getOutputs();
        if (outputs.length == 0) {
            return EMPTY_RESULT;
        }
        NNList result = new NNList();
        Random rand = new Random(nextSeed);
        for (RecipeOutput output : outputs) {
            if (output.isFluid()) {
                FluidStack fluidOutput = output.getFluidOutput();
                if (fluidOutput == null || !(rand.nextFloat() < output.getChance() * chanceMultiplier)) continue;
                result.add((Object)new IMachineRecipe.ResultStack(fluidOutput.copy()));
                continue;
            }
            ItemStack stack = output.getOutput().func_77946_l();
            int stackSize = 0;
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                if (!(rand.nextFloat() < output.getChance() * chanceMultiplier)) continue;
                ++stackSize;
            }
            stack.func_190920_e(stackSize);
            if (!Prep.isValid(stack)) continue;
            result.add((Object)new IMachineRecipe.ResultStack(stack));
        }
        return (IMachineRecipe.ResultStack[])result.toArray((Object[])EMPTY_RESULT);
    }
}

