/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.material.recipes;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.xml.Crafting;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.material.alloy.IAlloy;
import crazypants.enderio.base.material.alloy.endergy.AlloyEndergy;
import crazypants.enderio.base.material.glass.FusedQuartzType;
import crazypants.enderio.base.material.recipes.MaterialOredicts;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="enderio")
public class MaterialRecipes {
    @SubscribeEvent
    public static void register(@Nonnull RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        for (IAlloy alloy : new NNList((Object[])Alloy.values()).addAll((Object[])AlloyEndergy.values())) {
            registry.register(new ShapedOreRecipe(null, alloy.getStackBlock(), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), alloy.getOreIngot()}).setRegistryName(Crafting.mkRL("Auto: %s 1 block to 9 ingots", alloy.getBaseName())));
            registry.register(new ShapelessOreRecipe(null, alloy.getStackIngot(9), new Object[]{alloy.getOreBlock()}).setRegistryName(Crafting.mkRL("Auto: %s 9 ingots to 1 block", alloy.getBaseName())));
            registry.register(new ShapedOreRecipe(null, alloy.getStackIngot(), new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), alloy.getOreNugget()}).setRegistryName(Crafting.mkRL("Auto: %s 9 nuggets to 1 ingot", alloy.getBaseName())));
            registry.register(new ShapelessOreRecipe(null, alloy.getStackNugget(9), new Object[]{alloy.getStackIngot()}).setRegistryName(Crafting.mkRL("Auto: %s 1 ingot to 9 nuggets", alloy.getBaseName())));
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            for (FusedQuartzType type : FusedQuartzType.values()) {
                registry.register(new ShapedOreRecipe(null, new ItemStack(type.getBlock(), 8, color.func_176765_a()), new Object[]{"GGG", "CGG", "GGG", Character.valueOf('G'), type.getOreDictName(), Character.valueOf('C'), "dye" + MaterialOredicts.dyes[color.func_176767_b()]}).setRegistryName(Crafting.mkRL("Auto: Coloring %s with %s", type.func_176610_l(), color.func_176762_d())));
                if (color == EnumDyeColor.WHITE) continue;
                registry.register(new ShapedOreRecipe(null, new ItemStack(type.getBlock(), 8, color.func_176765_a()), new Object[]{"GGG", "CGG", "GGG", Character.valueOf('G'), new ItemStack(type.getBlock(), 1, EnumDyeColor.WHITE.func_176765_a()), Character.valueOf('C'), "dye" + MaterialOredicts.dyes[color.func_176767_b()]}).setRegistryName(Crafting.mkRL("Auto: Easy Lookup for coloring %s with %s", type.func_176610_l(), color.func_176762_d())));
            }
        }
    }
}

