/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.init;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.IModTileEntity;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.init.RegisterModObject;
import crazypants.enderio.util.O2OMap;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enderio")
public class ModObjectRegistry {
    @Nonnull
    private static final ResourceLocation NAME = new ResourceLocation("enderio", "modobject");
    private static IForgeRegistry<IModObject> REGISTRY = null;
    @Nonnull
    private static final NNList<IModTileEntity> tileEntities = new NNList();
    @Nonnull
    private static final O2OMap<ResourceLocation, IModObject> blockMap = new O2OMap();
    @Nonnull
    private static final O2OMap<ResourceLocation, IModObject> itemMap = new O2OMap();

    @SubscribeEvent
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(NAME).setType(IModObject.class).setIDRange(0, 0xFFFFFF).create();
    }

    @SubscribeEvent
    public static void registerRegistry(@Nonnull EnderIOLifecycleEvent.PreInit event) {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterModObject(NAME, (IForgeRegistry<IModObject>)((IForgeRegistry)NullHelper.notnullF(REGISTRY, (String)"RegistryBuilder.create()"))));
    }

    public static <T extends Enum<T>> void addModTileEntities(Class<T> enumClass) {
        tileEntities.addAll(Arrays.asList(enumClass.getEnumConstants()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerBlocksEarly(@Nonnull RegisterModObject event) {
        event.register(ModObject.class);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        for (IModObject mo : REGISTRY) {
            Block block = mo.getBlockCreator().apply(mo);
            if (block == null) continue;
            event.getRegistry().register((IForgeRegistryEntry)block);
            blockMap.putNoOverride(block.getRegistryName(), mo);
            ModObjectRegistry.checkUseNeighborBrightness(mo, block);
        }
    }

    private static void checkUseNeighborBrightness(IModObject mo, Block block) {
        if (System.getProperty("INDEV") != null && !block.func_149710_n(block.func_176223_P())) {
            boolean flag5;
            boolean flag1 = block instanceof BlockStairs;
            boolean flag2 = block instanceof BlockSlab;
            boolean flag4 = !block.func_149688_o(block.func_176223_P()).func_76228_b();
            boolean bl = flag5 = block.func_149717_k(block.func_176223_P()) == 0;
            if (flag1 || flag2 || flag4 || flag5) {
                Log.error("Block " + mo.getRegistryName() + " doesn't set useNeighborBrightness but it seems it should because: " + (flag1 ? "stairs " : "") + (flag2 ? "slab " : "") + (flag4 ? "translucent " : "") + (flag5 ? "lightOpacity " : ""));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerAddonBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        for (ModContainer modContainer : Loader.instance().getModList()) {
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            ((IEnderIOAddon)mod).injectBlocks((IForgeRegistry<Block>)((IForgeRegistry)NullHelper.notnullF((Object)event.getRegistry(), (String)"RegistryEvent.Register<Block>.getRegistry()")));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerTileEntities(@Nonnull RegistryEvent.Register<Block> event) {
        ModObjectRegistry.registerTeClasses();
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        for (IModObject mo : REGISTRY) {
            Item item = mo.getItemCreator().apply(mo, mo.getBlock());
            if (item == null) continue;
            event.getRegistry().register((IForgeRegistryEntry)item);
            itemMap.putNoOverride(item.getRegistryName(), mo);
        }
    }

    public static void dumpItems() {
        for (IModObject mo : REGISTRY) {
            Item item = mo.getItem();
            if (item == null) continue;
            for (CreativeTabs tab : item.getCreativeTabs()) {
                NNList list = new NNList();
                item.func_150895_a(tab, (NonNullList)list);
                for (ItemStack itemStack : list) {
                    int[] oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack);
                    if (oreIDs.length == 0) {
                        System.out.println("  <item name=\"" + itemStack.func_77973_b().getRegistryName() + ":" + itemStack.func_77952_i() + "\" show=\"false\" />");
                    } else {
                        System.out.println("  <item name=\"" + itemStack.func_77973_b().getRegistryName() + ":" + itemStack.func_77952_i() + "\" show=\"false\" /><!-- " + OreDictionary.getOreName((int)oreIDs[0]) + " -->");
                    }
                    for (int i : oreIDs) {
                        System.out.println("    <item name=\"" + OreDictionary.getOreName((int)i) + "\" show=\"false\" />");
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerOredict(@Nonnull RegistryEvent.Register<Item> event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void init(@Nonnull EnderIOLifecycleEvent.Init.Pre event) {
        for (IModObject mo : REGISTRY) {
            Item item;
            Block block = mo.getBlock();
            if (block instanceof IModObject.LifecycleInit) {
                ((IModObject.LifecycleInit)block).init(mo, event.getEvent());
            }
            if (!((item = mo.getItem()) instanceof IModObject.LifecycleInit)) continue;
            ((IModObject.LifecycleInit)item).init(mo, event.getEvent());
        }
    }

    public static void init(@Nonnull FMLPostInitializationEvent event) {
        for (IModObject mo : REGISTRY) {
            Item item;
            Block block = mo.getBlock();
            if (block instanceof IModObject.LifecyclePostInit) {
                ((IModObject.LifecyclePostInit)block).init(mo, event);
            }
            if (!((item = mo.getItem()) instanceof IModObject.LifecyclePostInit)) continue;
            ((IModObject.LifecyclePostInit)item).init(mo, event);
        }
    }

    private static void registerTeClasses() {
        for (IModTileEntity te : tileEntities) {
            Log.debug("Registering TileEntity " + te.getUnlocalisedName() + " as " + te.getRegistryName().toString());
            GameRegistry.registerTileEntity(te.getTileEntityClass(), (ResourceLocation)te.getRegistryName());
        }
    }

    @Nonnull
    public static String sanitizeName(@Nonnull String name) {
        return name.replaceAll("([A-Z])", "_$0").replaceFirst("^_", "").toLowerCase(Locale.ENGLISH);
    }

    @Nullable
    public static IModObject getModObject(@Nonnull Block forBlock) {
        return blockMap.getValue(forBlock.getRegistryName());
    }

    @Nonnull
    public static IModObject getModObjectNN(@Nonnull Block forBlock) {
        return (IModObject)NullHelper.notnull((Object)ModObjectRegistry.getModObject(forBlock), (String)("missing modObject for block " + forBlock.getRegistryName()));
    }

    @Nullable
    public static Block getBlock(@Nonnull IModObject forBlock) {
        ResourceLocation key = blockMap.getKey(forBlock);
        return key != null && Block.field_149771_c.func_148741_d((Object)key) ? (Block)Block.field_149771_c.func_82594_a((Object)key) : null;
    }

    @Nonnull
    public static Block getBlockNN(@Nonnull IModObject forBlock) {
        return (Block)NullHelper.notnull((Object)ModObjectRegistry.getBlock(forBlock), (String)("missing block for modObject " + forBlock.getRegistryName()));
    }

    @Nullable
    public static IModObject getModObject(@Nonnull Item forItem) {
        return itemMap.getValue(forItem.getRegistryName());
    }

    @Nonnull
    public static IModObject getModObjectNN(@Nonnull Item forItem) {
        return (IModObject)NullHelper.notnull((Object)ModObjectRegistry.getModObject(forItem), (String)("missing modObject for item " + forItem.getRegistryName()));
    }

    @Nullable
    public static Item getItem(@Nonnull IModObject forItem) {
        ResourceLocation key = itemMap.getKey(forItem);
        return key != null && Item.field_150901_e.func_148741_d((Object)key) ? (Item)Item.field_150901_e.func_82594_a((Object)key) : null;
    }

    @Nonnull
    public static Item getItemNN(@Nonnull IModObject forItem) {
        return (Item)NullHelper.notnull((Object)ModObjectRegistry.getItem(forItem), (String)("missing item for modObject " + forItem.getRegistryName()));
    }

    @Nonnull
    public static ForgeRegistry<IModObject> getRegistry() {
        return (ForgeRegistry)NullHelper.notnull(REGISTRY, (String)"accessing modobject registry too early");
    }
}

