/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileComponent;
import mekanism.common.base.ITileNetwork;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="ic2.api.tile.IWrenchable", modid="ic2")
public abstract class TileEntityBasicBlock
extends TileEntity
implements ITileNetwork,
IFrequencyHandler,
ITickable {
    public EnumFacing facing;
    public EnumFacing clientFacing;
    public Set<EntityPlayer> playersUsing;
    public int ticker;
    public boolean redstone;
    public boolean redstoneLastTick;
    public boolean doAutoSync;
    public List<ITileComponent> components;

    public TileEntityBasicBlock() {
        this.clientFacing = this.facing = EnumFacing.NORTH;
        this.playersUsing = new HashSet<EntityPlayer>();
        this.redstone = false;
        this.redstoneLastTick = false;
        this.doAutoSync = true;
        this.components = new ArrayList<ITileComponent>();
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(this)));
        }
    }

    public void func_73660_a() {
        BlockStateMachine.MachineType type;
        if (!this.field_145850_b.field_72995_K && MekanismConfig.current().general.destroyDisabledBlocks.val() && (type = BlockStateMachine.MachineType.get(this.func_145838_q(), this.func_145832_p())) != null && !type.isEnabled()) {
            Mekanism.logger.info("Destroying machine of type '" + type.getBlockName() + "' at coords " + Coord4D.get(this) + " as according to config.");
            this.field_145850_b.func_175698_g(this.func_174877_v());
            return;
        }
        for (ITileComponent component : this.components) {
            component.tick();
        }
        this.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.doAutoSync && this.playersUsing.size() > 0) {
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this), (EntityPlayerMP)player);
            }
        }
        ++this.ticker;
        this.redstoneLastTick = this.redstone;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.onAdded();
    }

    public void open(EntityPlayer player) {
        this.playersUsing.add(player);
    }

    public void close(EntityPlayer player) {
        this.playersUsing.remove(player);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.facing = EnumFacing.func_82600_a((int)dataStream.readInt());
            this.redstone = dataStream.readBoolean();
            if (this.clientFacing != this.facing) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c(), true);
                this.clientFacing = this.facing;
            }
            for (ITileComponent component : this.components) {
                component.read(dataStream);
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.facing == null ? -1 : this.facing.ordinal());
        data.add(this.redstone);
        for (ITileComponent component : this.components) {
            component.write(data);
        }
        return data;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (ITileComponent component : this.components) {
            component.invalidate();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(this)));
        }
    }

    public abstract void onUpdate();

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)nbtTags.func_74762_e("facing"));
        }
        this.redstone = nbtTags.func_74767_n("redstone");
        for (ITileComponent component : this.components) {
            component.read(nbtTags);
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.facing != null) {
            nbtTags.func_74768_a("facing", this.facing.ordinal());
        }
        nbtTags.func_74757_a("redstone", this.redstone);
        for (ITileComponent component : this.components) {
            component.write(nbtTags);
        }
        return nbtTags;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.TILE_NETWORK_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.TILE_NETWORK_CAPABILITY) {
            return (T)Capabilities.TILE_NETWORK_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setFacing(@Nonnull EnumFacing direction) {
        if (this.canSetFacing(direction)) {
            this.facing = direction;
        }
        if (this.facing != this.clientFacing && !this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.func_70296_d();
            this.clientFacing = this.facing;
        }
    }

    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return true;
    }

    public boolean isPowered() {
        return this.redstone;
    }

    public boolean wasPowered() {
        return this.redstoneLastTick;
    }

    public void onPowerChange() {
    }

    public void onNeighborChange(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.updatePower();
        }
    }

    private void updatePower() {
        boolean power;
        boolean bl = power = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        if (this.redstone != power) {
            this.redstone = power;
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.onPowerChange();
        }
    }

    public void onAdded() {
        this.updatePower();
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies && this instanceof ISecurityTile) {
            return ((ISecurityTile)((Object)this)).getSecurity().getFrequency();
        }
        return null;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return super.func_189517_E_();
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
    }
}

