/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.generators;

import ipsis.Woot;
import ipsis.woot.init.ModItems;
import ipsis.woot.loot.LootGenerationFarmInfo;
import ipsis.woot.loot.generators.ILootGenerator;
import ipsis.woot.util.ConfigKeyHelper;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumFarmUpgrade;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class XpGenerator
implements ILootGenerator {
    private static final int XP_CHUNKS = 16;

    @Override
    public void generate(World world, LootGenerationFarmInfo farmInfo) {
        if (farmInfo == null) {
            return;
        }
        if (farmInfo.itemHandlerList.size() == 0) {
            return;
        }
        if (!farmInfo.farmSetup.hasUpgrade(EnumFarmUpgrade.XP)) {
            return;
        }
        int storedXp = farmInfo.farmSetup.getStoredXp();
        int deathXp = Woot.wootConfiguration.getDeathCost(world, farmInfo.farmSetup.getWootMobName());
        float increase = Woot.wootConfiguration.getInteger(farmInfo.farmSetup.getWootMobName(), ConfigKeyHelper.getXpParam(farmInfo.farmSetup.getUpgradeLevel(EnumFarmUpgrade.XP)));
        int totalXp = (storedXp %= 16) + (deathXp *= farmInfo.farmSetup.getNumMobs());
        float extraXp = (increase - 100.0f) / 100.0f * (float)totalXp;
        int generate = (totalXp += (int)extraXp) / 16;
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_XP, "generate", "storedXp:" + storedXp + " deathXp:" + deathXp + " totalXp:" + totalXp + " generate:" + generate);
        if (generate != 0) {
            ItemStack itemStack = new ItemStack((Item)ModItems.itemXpShard, generate);
            for (IItemHandler hdlr : farmInfo.itemHandlerList) {
                if (itemStack.func_190926_b()) continue;
                boolean success = true;
                while (success && !itemStack.func_190926_b()) {
                    ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)hdlr, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1), (boolean)false);
                    if (result.func_190926_b()) {
                        itemStack.func_190918_g(1);
                        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_XP, "generate", "placed xp in itemhandler with slots " + hdlr.getSlots());
                        continue;
                    }
                    success = false;
                }
            }
        }
        storedXp = totalXp - generate * 16;
        farmInfo.farmSetup.setStoredXp(storedXp %= 16);
    }
}

