/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.IMoCTameable;
import drzhark.mocreatures.entity.ai.EntityAIMoverHelperMoC;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MoCEntityAquatic
extends EntityCreature
implements IMoCEntity {
    protected boolean divePending;
    protected boolean jumpPending;
    protected boolean isEntityJumping;
    protected int outOfWater = 0;
    private boolean diving;
    private int divingCount;
    private int mountCount;
    public boolean fishHooked;
    protected boolean riderIsDisconnecting;
    protected float moveSpeed;
    protected String texture;
    protected PathNavigate navigatorWater;
    private boolean updateDivingDepth = false;
    private double divingDepth;
    protected int temper;
    protected static final DataParameter<Boolean> ADULT = EntityDataManager.func_187226_a(MoCEntityAquatic.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(MoCEntityAquatic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(MoCEntityAquatic.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> NAME_STR = EntityDataManager.func_187226_a(MoCEntityAquatic.class, (DataSerializer)DataSerializers.field_187194_d);

    public MoCEntityAquatic(World world) {
        super(world);
        this.setTemper(50);
        this.setNewDivingDepth();
        this.riderIsDisconnecting = false;
        this.texture = "blank.jpg";
        this.navigatorWater = new PathNavigateSwimmer((EntityLiving)this, world);
        this.field_70765_h = new EntityAIMoverHelperMoC((EntityLiving)this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.getMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getTexture(this.texture);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.selectType();
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ADULT, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(AGE, (Object)45);
        this.field_70180_af.func_187214_a(NAME_STR, (Object)"");
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_187227_b(TYPE, (Object)i);
    }

    @Override
    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    @Override
    public int getOwnerPetId() {
        return -1;
    }

    @Override
    public void setOwnerPetId(int i) {
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return null;
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.field_70180_af.func_187225_a(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.field_70180_af.func_187227_b(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.field_70180_af.func_187225_a(NAME_STR);
    }

    @Override
    public int getEdad() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    @Override
    public void setEdad(int i) {
        this.field_70180_af.func_187227_b(AGE, (Object)i);
    }

    @Override
    public void setPetName(String name) {
        this.field_70180_af.func_187227_b(NAME_STR, (Object)name);
    }

    public int getTemper() {
        return this.temper;
    }

    public void setTemper(int i) {
        this.temper = i;
    }

    public int getMaxTemper() {
        return 100;
    }

    public float b(float f, float f1, float f2) {
        float f3 = f1;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public void faceItem(int i, int j, int k, float f) {
        double d = (double)i - this.field_70165_t;
        double d1 = (double)k - this.field_70161_v;
        double d2 = (double)j - this.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        float f1 = (float)(Math.atan2(d1, d) * 180.0 / 3.141592741012573) - 90.0f;
        float f2 = (float)(Math.atan2(d2, d3) * 180.0 / 3.141592741012573);
        this.field_70125_A = -this.b(this.field_70125_A, f2, f);
        this.field_70177_z = this.b(this.field_70177_z, f1, f);
    }

    protected boolean func_70692_ba() {
        if (MoCreatures.proxy.forceDespawns) {
            return !this.getIsTamed();
        }
        return false;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    protected void func_180429_a(BlockPos pos, Block par4) {
    }

    public void func_180430_e(float f, float f1) {
    }

    public EntityItem getClosestFish(Entity entity, double d) {
        double d1 = -1.0;
        EntityItem entityitem = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            EntityItem entityitem1;
            Entity entity1 = (Entity)list.get(i);
            if (!(entity1 instanceof EntityItem) || (entityitem1 = (EntityItem)entity1).func_92059_d().func_77973_b() != Items.field_151115_aP || !entityitem1.func_70090_H()) continue;
            double d2 = entityitem1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d < 0.0) && !(d2 < d * d) || d1 != -1.0 && !(d2 < d1)) continue;
            d1 = d2;
            entityitem = entityitem1;
        }
        return entityitem;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean gettingOutOfWater() {
        int i = (int)this.field_70165_t;
        int j = (int)this.field_70163_u;
        int k = (int)this.field_70161_v;
        return this.field_70170_p.func_175623_d(new BlockPos(i, j + 1, k));
    }

    public double getCustomJump() {
        return 0.4;
    }

    public void setIsJumping(boolean flag) {
        this.isEntityJumping = flag;
    }

    public boolean getIsJumping() {
        return this.isEntityJumping;
    }

    @Override
    public void makeEntityJump() {
        this.jumpPending = true;
    }

    protected boolean MoveToNextEntity(Entity entity) {
        if (entity != null) {
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            this.faceItem(i, j, k, 30.0f);
            if (this.field_70165_t < (double)i) {
                double d = entity.field_70165_t - this.field_70165_t;
                if (d > 0.5) {
                    this.field_70159_w += 0.05;
                }
            } else {
                double d1 = this.field_70165_t - entity.field_70165_t;
                if (d1 > 0.5) {
                    this.field_70159_w -= 0.05;
                }
            }
            if (this.field_70161_v < (double)k) {
                double d2 = entity.field_70161_v - this.field_70161_v;
                if (d2 > 0.5) {
                    this.field_70179_y += 0.05;
                }
            } else {
                double d3 = this.field_70161_v - entity.field_70161_v;
                if (d3 > 0.5) {
                    this.field_70179_y -= 0.05;
                }
            }
            return true;
        }
        return false;
    }

    public double getCustomSpeed() {
        return 1.5;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72321_a(0.0, -0.2, 0.0), Material.field_151586_h, (Entity)this);
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean isDiving() {
        return this.diving;
    }

    protected void func_70664_aZ() {
    }

    public void Riding() {
        if (this.func_184207_aI() && this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)this.func_184187_bx();
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(1.0, 0.0, 1.0));
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    float f;
                    Entity entity = (Entity)list.get(i);
                    if (entity.field_70128_L) continue;
                    entity.func_70100_b_(entityplayer);
                    if (!(entity instanceof EntityMob) || !((f = this.func_70032_d(entity)) < 2.0f) || !(entity instanceof EntityMob) || this.field_70146_Z.nextInt(10) != 0) continue;
                    this.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)entity)), (float)((EntityMob)entity).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                }
            }
        }
    }

    @Override
    public boolean isMovementCeased() {
        return !this.isSwimming() && !this.func_184207_aI() || this.func_184207_aI() || this.getIsSitting();
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184207_aI()) {
                this.Riding();
                this.mountCount = 1;
            }
            if (this.mountCount > 0 && ++this.mountCount > 50) {
                this.mountCount = 0;
            }
            if (this.getEdad() == 0) {
                this.setEdad(this.getMaxEdad() - 10);
            }
            if (!this.getIsAdult() && this.field_70146_Z.nextInt(300) == 0) {
                this.setEdad(this.getEdad() + 1);
                if (this.getEdad() >= this.getMaxEdad()) {
                    this.setAdult(true);
                }
            }
            this.func_70661_as().func_75501_e();
            if (!this.func_70661_as().func_75500_f()) {
                if (!this.updateDivingDepth) {
                    float targetDepth = MoCTools.distanceToSurface(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), this.field_70170_p);
                    this.setNewDivingDepth(targetDepth);
                    this.updateDivingDepth = true;
                }
            } else {
                this.updateDivingDepth = false;
            }
            if (this.isMovementCeased() || this.field_70146_Z.nextInt(200) == 0) {
                this.func_70661_as().func_75499_g();
            }
            if (this.isFisheable() && !this.fishHooked && this.field_70146_Z.nextInt(30) == 0) {
                this.getFished();
            }
            if (this.fishHooked && this.field_70146_Z.nextInt(200) == 0) {
                this.fishHooked = false;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity1 = (Entity)list.get(i);
                    if (!(entity1 instanceof EntityFishHook) || ((EntityFishHook)entity1).field_146043_c != this) continue;
                    ((EntityFishHook)entity1).field_146043_c = null;
                }
            }
        }
        this.moveSpeed = this.getMoveSpeed();
        if (this.isSwimming()) {
            this.outOfWater = 0;
            this.func_70050_g(800);
        } else {
            ++this.outOfWater;
            this.field_70181_x -= 0.1;
            if (this.outOfWater > 20) {
                this.func_70661_as().func_75499_g();
            }
            if (this.outOfWater > 300 && this.outOfWater % 40 == 0) {
                this.field_70181_x += 0.3;
                this.field_70159_w = (float)(Math.random() * 0.2 - 0.1);
                this.field_70179_y = (float)(Math.random() * 0.2 - 0.1);
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
        if (!this.diving) {
            if (!this.func_184207_aI() && this.func_70638_az() == null && !this.field_70699_by.func_75500_f() && this.field_70146_Z.nextInt(500) == 0) {
                this.diving = true;
            }
        } else {
            ++this.divingCount;
            if (this.divingCount > 100 || this.func_184207_aI()) {
                this.diving = false;
                this.divingCount = 0;
            }
        }
        super.func_70636_d();
    }

    public boolean isSwimming() {
        return this.func_70055_a(Material.field_151586_h);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Adult", this.getIsAdult());
        nbttagcompound.func_74768_a("Edad", this.getEdad());
        nbttagcompound.func_74778_a("Name", this.getPetName());
        nbttagcompound.func_74768_a("TypeInt", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setAdult(nbttagcompound.func_74767_n("Adult"));
        this.setEdad(nbttagcompound.func_74762_e("Edad"));
        this.setPetName(nbttagcompound.func_74779_i("Name"));
        this.setType(nbttagcompound.func_74762_e("TypeInt"));
    }

    public void setDisplayName(boolean flag) {
    }

    public void setTypeInt(int i) {
        this.setType(i);
        this.selectType();
    }

    @Override
    public void performAnimation(int attackType) {
    }

    protected void func_70623_bb() {
        EntityPlayer var1 = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        if (var1 != null) {
            double var2 = var1.field_70165_t - this.field_70165_t;
            double var4 = var1.field_70163_u - this.field_70163_u;
            double var6 = var1.field_70161_v - this.field_70161_v;
            double var8 = var2 * var2 + var4 * var4 + var6 * var6;
            if (this.func_70692_ba() && var8 > 16384.0) {
                this.func_70106_y();
            }
            if (this.field_70708_bq > 1800 && this.field_70146_Z.nextInt(800) == 0 && var8 > 1024.0 && this.func_70692_ba()) {
                this.func_70106_y();
            } else if (var8 < 1024.0) {
                this.field_70708_bq = 0;
            }
        }
    }

    public float getMoveSpeed() {
        return 0.7f;
    }

    @Override
    public int nameYOffset() {
        return 0;
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().equals("") && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public void makeEntityDive() {
        this.divePending = true;
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public boolean func_70601_bi() {
        return MoCreatures.entityMap.get(this.getClass()).getFrequency() > 0 && this.field_70170_p.func_72855_b(this.func_174813_aQ());
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.usesNewAI()) {
            return super.func_70097_a(damagesource, i);
        }
        if (this.isNotScared()) {
            EntityLivingBase tempEntity = this.func_70638_az();
            this.func_70624_b(tempEntity);
            return super.func_70097_a(damagesource, i);
        }
        return super.func_70097_a(damagesource, i);
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    protected void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemstack) {
        return false;
    }

    @Override
    public void setArmorType(int i) {
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    private void getFished() {
        EntityFishHook fishHook;
        EntityPlayer entityplayer1 = this.field_70170_p.func_72890_a((Entity)this, 18.0);
        if (entityplayer1 != null && (fishHook = entityplayer1.field_71104_cf) != null && fishHook.field_146043_c == null) {
            float f = fishHook.func_70032_d((Entity)this);
            if (f > 1.0f) {
                MoCTools.getPathToEntity((EntityLiving)this, (Entity)fishHook, f);
            } else {
                fishHook.field_146043_c = this;
                this.fishHooked = true;
            }
        }
    }

    protected boolean isFisheable() {
        return false;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected EntityLivingBase getBoogey(double d) {
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(d, 4.0, d));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!this.entitiesToInclude(entity)) continue;
            entityliving = (EntityLivingBase)entity;
        }
        return entityliving;
    }

    public boolean entitiesToInclude(Entity entity) {
        return entity.getClass() != this.getClass() && entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && !MoCTools.isThisPlayerAnOP(player) && this.getIsTamed() && !player.func_110124_au().equals(this.getOwnerId())) {
            return false;
        }
        return super.func_184652_a(player);
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean shouldAttackPlayers() {
        return !this.getIsTamed() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70090_H()) {
            if (this.func_184207_aI()) {
                EntityLivingBase passenger = (EntityLivingBase)this.func_184179_bs();
                if (passenger != null) {
                    this.moveWithRider(strafe, vertical, forward, passenger);
                }
                return;
            }
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
            if (this.func_70638_az() == null) {
                this.field_70181_x -= 0.005;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d2 = this.field_70165_t - this.field_70169_q;
            double d3 = this.field_70161_v - this.field_70166_s;
            float f7 = MathHelper.func_76133_a((double)(d2 * d2 + d3 * d3)) * 4.0f;
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            this.field_70721_aZ += (f7 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void moveWithRider(float strafe, float vertical, float forward, EntityLivingBase passenger) {
        if (passenger == null) {
            return;
        }
        if (this.func_184207_aI() && !this.getIsTamed() && !this.isSwimming()) {
            this.func_184226_ay();
            return;
        }
        if (this.func_184207_aI() && !this.getIsTamed() && passenger instanceof EntityLivingBase) {
            this.moveWithRiderUntamed(strafe, vertical, forward, passenger);
            return;
        }
        if (this.func_184207_aI() && this.getIsTamed() && passenger instanceof EntityLivingBase) {
            this.field_70126_B = this.field_70177_z = passenger.field_70177_z;
            this.field_70125_A = passenger.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = passenger.field_70702_br * 0.35f;
            forward = passenger.field_191988_bg * (float)(this.getCustomSpeed() / 5.0);
            if (this.jumpPending) {
                if (this.isSwimming()) {
                    this.field_70181_x += this.getCustomJump();
                }
                this.jumpPending = false;
            }
            if (this.field_70181_x < 0.0 && this.isSwimming()) {
                this.field_70181_x = 0.0;
            }
            if (this.divePending) {
                this.divePending = false;
                this.field_70181_x -= 0.3;
            }
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            super.func_191986_a(strafe, vertical, forward);
            this.func_191958_b(strafe, vertical, forward, 0.1f);
        }
    }

    public void moveWithRiderUntamed(float strafe, float vertical, float forward, EntityLivingBase passenger) {
        if (this.func_184207_aI() && !this.getIsTamed()) {
            if (this.field_70146_Z.nextInt(5) == 0 && !this.getIsJumping() && this.jumpPending) {
                this.field_70181_x += this.getCustomJump();
                this.setIsJumping(true);
                this.jumpPending = false;
            }
            if (this.field_70146_Z.nextInt(10) == 0) {
                this.field_70159_w += this.field_70146_Z.nextDouble() / 30.0;
                this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(100) == 0) {
                passenger.field_70181_x += 0.9;
                passenger.field_70179_y -= 0.3;
                passenger.func_184210_p();
            }
            if (this.field_70122_E) {
                this.setIsJumping(false);
            }
            if (!this.field_70170_p.field_72995_K && this instanceof IMoCTameable && passenger instanceof EntityPlayer) {
                int chance = this.getMaxTemper() - this.getTemper();
                if (chance <= 0) {
                    chance = 1;
                }
                if (this.field_70146_Z.nextInt(chance * 8) == 0) {
                    MoCTools.tameWithName((EntityPlayer)passenger, (IMoCTameable)((Object)this));
                }
            }
        }
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 300;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -30) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
                this.field_70159_w += this.field_70146_Z.nextDouble() / 10.0;
                this.field_70179_y += this.field_70146_Z.nextDouble() / 10.0;
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected boolean usesNewAI() {
        return false;
    }

    public PathNavigate func_70661_as() {
        if (this.func_70090_H()) {
            return this.navigatorWater;
        }
        return this.field_70699_by;
    }

    @Override
    public double getDivingDepth() {
        return (float)this.divingDepth;
    }

    protected void setNewDivingDepth(double setDepth) {
        if (setDepth != 0.0) {
            if (setDepth > this.maxDivingDepth()) {
                setDepth = this.maxDivingDepth();
            }
            if (setDepth < this.minDivingDepth()) {
                setDepth = this.minDivingDepth();
            }
            this.divingDepth = setDepth;
        } else {
            this.divingDepth = (float)(this.field_70146_Z.nextDouble() * (this.maxDivingDepth() - this.minDivingDepth()) + this.minDivingDepth());
        }
    }

    protected void setNewDivingDepth() {
        this.setNewDivingDepth(0.0);
    }

    protected double minDivingDepth() {
        return 0.2;
    }

    protected double maxDivingDepth() {
        return 3.0;
    }

    @Override
    public void forceEntityJump() {
        this.func_70664_aZ();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float yawRotationOffset() {
        double d4 = 0.0;
        if (this.field_70159_w != 0.0 || this.field_70179_y != 0.0) {
            d4 = Math.sin((double)this.field_70173_aa * 0.5) * 8.0;
        }
        return (float)d4;
    }

    public int getMaxEdad() {
        return 100;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!entityIn.func_70090_H()) {
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Override
    public int maxFlyingHeight() {
        return 1;
    }

    @Override
    public int minFlyingHeight() {
        return 1;
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }

    protected SoundEvent getUpsetSound() {
        return SoundEvents.field_187543_bD;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.WATER_CREATURE;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public String getClazzString() {
        return EntityList.func_75621_b((Entity)this);
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }

    public void func_110162_b(Entity entityIn, boolean sendAttachNotification) {
        if (this.getIsTamed() && entityIn instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !entityplayer.func_110124_au().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(entityplayer)) {
                return;
            }
        }
        super.func_110162_b(entityIn, sendAttachNotification);
    }
}

