/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class VertexArray {
    private FloatBuffer va;

    public FloatBuffer allocate(int maxQuads) {
        int capacity = 16 * maxQuads;
        if (this.va == null || this.va.capacity() < capacity) {
            this.va = BufferUtils.createFloatBuffer((int)capacity);
        }
        this.va.clear();
        return this.va;
    }

    public void bind() {
        this.va.position(2);
        GL11.glVertexPointer((int)2, (int)16, (FloatBuffer)this.va);
        this.va.position(0);
        GL11.glTexCoordPointer((int)2, (int)16, (FloatBuffer)this.va);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
    }

    public void drawVertices(int start, int count) {
        GL11.glDrawArrays((int)7, (int)start, (int)count);
    }

    public void drawQuads(int start, int count) {
        GL11.glDrawArrays((int)7, (int)(start * 4), (int)(count * 4));
    }

    public void unbind() {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
    }
}

