/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractListModel;
import de.matthiasmann.twl.model.ListModel;
import java.util.Comparator;
import java.util.Random;

public class ReorderListModel<T>
extends AbstractListModel<T> {
    private final ListModel<T> base;
    private final ListModel.ChangeListener listener;
    private int[] reorderList;
    private int size;
    private static final int INSERTIONSORT_THRESHOLD = 7;

    public ReorderListModel(ListModel<T> base) {
        this.base = base;
        this.reorderList = new int[0];
        this.listener = new ListModel.ChangeListener(){

            @Override
            public void entriesInserted(int first, int last) {
                ReorderListModel.this.entriesInserted(first, last);
            }

            @Override
            public void entriesDeleted(int first, int last) {
                ReorderListModel.this.entriesDeleted(first, last);
            }

            @Override
            public void entriesChanged(int first, int last) {
            }

            @Override
            public void allChanged() {
                ReorderListModel.this.buildNewList();
            }
        };
        base.addChangeListener(this.listener);
        this.buildNewList();
    }

    public void destroy() {
        this.base.removeChangeListener(this.listener);
    }

    @Override
    public int getNumEntries() {
        return this.size;
    }

    @Override
    public T getEntry(int index) {
        int remappedIndex = this.reorderList[index];
        return this.base.getEntry(remappedIndex);
    }

    @Override
    public Object getEntryTooltip(int index) {
        int remappedIndex = this.reorderList[index];
        return this.base.getEntryTooltip(remappedIndex);
    }

    @Override
    public boolean matchPrefix(int index, String prefix) {
        int remappedIndex = this.reorderList[index];
        return this.base.matchPrefix(remappedIndex, prefix);
    }

    public int findEntry(Object o) {
        int[] list = this.reorderList;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            T entry = this.base.getEntry(list[i]);
            if (entry != o && (entry == null || !entry.equals(o))) continue;
            return i;
        }
        return -1;
    }

    public void shuffle() {
        Random r = new Random();
        int i = this.size;
        while (i > 1) {
            int j = r.nextInt(i--);
            int temp = this.reorderList[i];
            this.reorderList[i] = this.reorderList[j];
            this.reorderList[j] = temp;
        }
        this.fireAllChanged();
    }

    public void sort(Comparator<T> c) {
        int[] aux = new int[this.size];
        System.arraycopy(this.reorderList, 0, aux, 0, this.size);
        this.mergeSort(aux, this.reorderList, 0, this.size, c);
        this.fireAllChanged();
    }

    private void mergeSort(int[] src, int[] dest, int low, int high, Comparator<T> c) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && this.compare(dest, j - 1, j, c) > 0; --j) {
                    ReorderListModel.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >>> 1;
        this.mergeSort(dest, src, low, mid, c);
        this.mergeSort(dest, src, mid, high, c);
        if (this.compare(src, mid - 1, mid, c) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && this.compare(src, p, q, c) <= 0 ? src[p++] : src[q++];
        }
    }

    private int compare(int[] list, int a, int b, Comparator<T> c) {
        int aIdx = list[a];
        int bIdx = list[b];
        T objA = this.base.getEntry(aIdx);
        T objB = this.base.getEntry(bIdx);
        return c.compare(objA, objB);
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private void buildNewList() {
        this.size = this.base.getNumEntries();
        this.reorderList = new int[this.size + 1024];
        for (int i = 0; i < this.size; ++i) {
            this.reorderList[i] = i;
        }
        this.fireAllChanged();
    }

    private void entriesInserted(int first, int last) {
        int delta = last - first + 1;
        for (int i = 0; i < this.size; ++i) {
            if (this.reorderList[i] < first) continue;
            int n = i;
            this.reorderList[n] = this.reorderList[n] + delta;
        }
        if (this.size + delta > this.reorderList.length) {
            int[] newList = new int[Math.max(this.size * 2, this.size + delta + 1024)];
            System.arraycopy(this.reorderList, 0, newList, 0, this.size);
            this.reorderList = newList;
        }
        int oldSize = this.size;
        for (int i = 0; i < delta; ++i) {
            this.reorderList[this.size++] = first + i;
        }
        this.fireEntriesInserted(oldSize, this.size - 1);
    }

    private void entriesDeleted(int first, int last) {
        int delta = last - first + 1;
        for (int i = 0; i < this.size; ++i) {
            int entry = this.reorderList[i];
            if (entry < first) continue;
            if (entry <= last) {
                this.entriesDeletedCopy(first, last, i);
                return;
            }
            this.reorderList[i] = entry - delta;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void entriesDeletedCopy(int first, int last, int i) {
        delta = last - first + 1;
        oldSize = this.size;
        j = i;
        while (i < oldSize) {
            entry = this.reorderList[i];
            if (entry < first) ** GOTO lbl12
            if (entry <= last) {
                --this.size;
                this.fireEntriesDeleted(j, j);
            } else {
                entry -= delta;
lbl12:
                // 2 sources

                this.reorderList[j++] = entry;
            }
            ++i;
        }
        if (!ReorderListModel.$assertionsDisabled && this.size != j) {
            throw new AssertionError();
        }
    }
}

