/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.GraphLineModel;
import de.matthiasmann.twl.model.GraphModel;
import de.matthiasmann.twl.renderer.LineRenderer;
import de.matthiasmann.twl.utils.TextUtil;
import java.util.Arrays;

public class Graph
extends Widget {
    private final GraphArea area;
    GraphModel model;
    private ParameterMap themeLineStyles;
    private int sizeMultipleX = 1;
    private int sizeMultipleY = 1;
    LineStyle[] lineStyles = new LineStyle[8];
    private float[] renderXYBuffer = new float[128];
    private static final float EPSILON = 1.0E-4f;

    public Graph() {
        this.area = new GraphArea();
        this.area.setClip(true);
        this.add(this.area);
    }

    public Graph(GraphModel model) {
        this();
        this.setModel(model);
    }

    public GraphModel getModel() {
        return this.model;
    }

    public void setModel(GraphModel model) {
        this.model = model;
        this.invalidateLineStyles();
    }

    public int getSizeMultipleX() {
        return this.sizeMultipleX;
    }

    public void setSizeMultipleX(int sizeMultipleX) {
        if (sizeMultipleX < 1) {
            throw new IllegalArgumentException("sizeMultipleX must be >= 1");
        }
        this.sizeMultipleX = sizeMultipleX;
    }

    public int getSizeMultipleY() {
        return this.sizeMultipleY;
    }

    public void setSizeMultipleY(int sizeMultipleY) {
        if (sizeMultipleY < 1) {
            throw new IllegalArgumentException("sizeMultipleX must be >= 1");
        }
        this.sizeMultipleY = sizeMultipleY;
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeGraph(themeInfo);
    }

    protected void applyThemeGraph(ThemeInfo themeInfo) {
        this.themeLineStyles = themeInfo.getParameterMap("lineStyles");
        this.setSizeMultipleX(themeInfo.getParameter("sizeMultipleX", 1));
        this.setSizeMultipleY(themeInfo.getParameter("sizeMultipleY", 1));
        this.invalidateLineStyles();
    }

    protected void invalidateLineStyles() {
        Arrays.fill(this.lineStyles, null);
    }

    void syncLineStyles() {
        int numLines = this.model.getNumLines();
        if (this.lineStyles.length < numLines) {
            LineStyle[] newLineStyles = new LineStyle[numLines];
            System.arraycopy(this.lineStyles, 0, newLineStyles, 0, this.lineStyles.length);
            this.lineStyles = newLineStyles;
        }
        for (int i = 0; i < numLines; ++i) {
            String visualStyle;
            GraphLineModel line = this.model.getLine(i);
            LineStyle style = this.lineStyles[i];
            if (style == null) {
                this.lineStyles[i] = style = new LineStyle();
            }
            if (style.name.equals(visualStyle = TextUtil.notNull(line.getVisualStyleName()))) continue;
            ParameterMap lineStyle = null;
            if (this.themeLineStyles != null) {
                lineStyle = this.themeLineStyles.getParameterMap(visualStyle);
            }
            style.setStyleName(visualStyle, lineStyle);
        }
    }

    void renderLine(LineRenderer lineRenderer, GraphLineModel line, float minValue, float maxValue, LineStyle style) {
        int numPoints = line.getNumPoints();
        if (numPoints <= 0) {
            return;
        }
        if (this.renderXYBuffer.length < numPoints * 2) {
            this.renderXYBuffer = new float[numPoints * 2];
        }
        float[] xy = this.renderXYBuffer;
        float delta = maxValue - minValue;
        if (Math.abs(delta) < 1.0E-4f) {
            delta = Graph.copySign(1.0E-4f, delta);
        }
        float yscale = (float)(-this.getInnerHeight()) / delta;
        float yoff = this.getInnerBottom();
        float xscale = (float)this.getInnerWidth() / (float)Math.max(1, numPoints - 1);
        float xoff = this.getInnerX();
        for (int i = 0; i < numPoints; ++i) {
            float value = line.getPoint(i);
            xy[i * 2 + 0] = (float)i * xscale + xoff;
            xy[i * 2 + 1] = (value - minValue) * yscale + yoff;
        }
        if (numPoints == 1) {
            xy[2] = xoff + xscale;
            xy[3] = xy[1];
            numPoints = 2;
        }
        lineRenderer.drawLine(xy, numPoints, style.lineWidth, style.color, false);
    }

    private static float copySign(float magnitude, float sign) {
        int rawMagnitude = Float.floatToRawIntBits(magnitude);
        int rawSign = Float.floatToRawIntBits(sign);
        int rawResult = rawMagnitude | rawSign & Integer.MIN_VALUE;
        return Float.intBitsToFloat(rawResult);
    }

    @Override
    public boolean setSize(int width, int height) {
        return super.setSize(Graph.round(width, this.sizeMultipleX), Graph.round(height, this.sizeMultipleY));
    }

    private static int round(int value, int grid) {
        return value - value % grid;
    }

    @Override
    protected void layout() {
        this.layoutChildFullInnerArea(this.area);
    }

    class GraphArea
    extends Widget {
        GraphArea() {
        }

        @Override
        protected void paintWidget(GUI gui) {
            if (Graph.this.model != null) {
                GraphLineModel line;
                int i;
                Graph.this.syncLineStyles();
                LineRenderer lineRenderer = gui.getRenderer().getLineRenderer();
                int numLines = Graph.this.model.getNumLines();
                boolean independantScale = Graph.this.model.getScaleLinesIndependant();
                float minValue = Float.MAX_VALUE;
                float maxValue = -3.4028235E38f;
                if (independantScale) {
                    for (i = 0; i < numLines; ++i) {
                        line = Graph.this.model.getLine(i);
                        minValue = Math.min(minValue, line.getMinValue());
                        maxValue = Math.max(maxValue, line.getMaxValue());
                    }
                }
                for (i = 0; i < numLines; ++i) {
                    line = Graph.this.model.getLine(i);
                    LineStyle style = Graph.this.lineStyles[i];
                    if (independantScale) {
                        Graph.this.renderLine(lineRenderer, line, minValue, maxValue, style);
                        continue;
                    }
                    Graph.this.renderLine(lineRenderer, line, line.getMinValue(), line.getMaxValue(), style);
                }
            }
        }
    }

    static class LineStyle {
        String name = "";
        Color color = Color.WHITE;
        float lineWidth = 1.0f;

        LineStyle() {
        }

        void setStyleName(String name, ParameterMap lineStyle) {
            this.name = name;
            if (lineStyle != null) {
                this.color = lineStyle.getParameter("color", Color.WHITE);
                this.lineWidth = Math.max(1.0E-4f, lineStyle.getParameter("width", 1.0f));
            }
        }
    }
}

