/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tiles.chests;

import QuantumStorage.client.AdvancedGui;
import QuantumStorage.config.ConfigQuantumStorage;
import QuantumStorage.init.ModBlocks;
import QuantumStorage.tiles.AdvancedTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import reborncore.common.util.RebornCraftingHelper;

public class TileChestDiamond
extends AdvancedTileEntity {
    protected static final AxisAlignedBB CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public TileChestDiamond() {
        this.inv = new ItemStackHandler(91);
    }

    @Override
    public String getName() {
        return "chest_diamond";
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CHEST_AABB;
    }

    @Override
    public List<Slot> getSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int i = 0;
        for (int l = 0; l < 7; ++l) {
            for (int j1 = 0; j1 < 13; ++j1) {
                slots.add((Slot)new SlotItemHandler((IItemHandler)this.getInv(), i, 8 + j1 * 18, 11 + l * 18));
                ++i;
            }
        }
        return slots;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop, int xSize, int ySize, AdvancedGui gui) {
        this.getBuilder().drawDefaultBackground((GuiScreen)gui, guiLeft, guiTop, xSize, ySize);
        this.getBuilder().drawPlayerSlots((GuiScreen)gui, guiLeft + xSize / 2, guiTop + 150, true);
        if (this.getSlots() != null) {
            for (Slot s : this.getSlots()) {
                this.getBuilder().drawSlot((GuiScreen)gui, guiLeft + s.field_75223_e - 1, guiTop + s.field_75221_f - 1);
            }
        }
    }

    @Override
    public int getXSize() {
        return 250;
    }

    @Override
    public int getYsize() {
        return 240;
    }

    @Override
    public int inventoryOffsetX() {
        return 45;
    }

    @Override
    public int inventoryOffsetY() {
        return 151;
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileChestDiamond();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.openGui(playerIn, (AdvancedTileEntity)worldIn.func_175625_s(pos));
        return true;
    }

    @Override
    public Block getBlock() {
        return ModBlocks.CHEST_DIAMOND;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_179237_a(this.inv.serializeNBT());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inv.deserializeNBT(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getInv());
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void addRecipe() {
        if (!ConfigQuantumStorage.disableChests) {
            RebornCraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.CHEST_DIAMOND), (Object[])new Object[]{"WXW", "ICI", "WXW", Character.valueOf('W'), "plankWood", Character.valueOf('X'), "chest", Character.valueOf('I'), new ItemStack(Items.field_151045_i), Character.valueOf('C'), new ItemStack(ModBlocks.CHEST_GOLD)});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("Keeps Inventory when broken");
        super.addInformation(stack, world, tooltip, advanced);
    }
}

