/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tiles;

import QuantumStorage.client.AdvancedGui;
import QuantumStorage.config.ConfigQuantumStorage;
import QuantumStorage.init.ModBlocks;
import QuantumStorage.tiles.AdvancedTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.RebornCraftingHelper;

public class TileQuantumTank
extends AdvancedTileEntity
implements ITickable {
    FluidTank tank = new FluidTank(Integer.MAX_VALUE);

    @Override
    public String getName() {
        return "quantum_tank";
    }

    @Override
    public List<Slot> getSlots() {
        return null;
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileQuantumTank();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.sync();
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)side)) {
            return true;
        }
        if (worldIn.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            IFluidTank handler = (IFluidTank)worldIn.func_175625_s(pos).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            if (!playerIn.func_184586_b(hand).func_190926_b() && ItemUtils.isItemEqual((ItemStack)playerIn.func_184586_b(hand), (ItemStack)new ItemStack(Blocks.field_192444_dS), (boolean)false, (boolean)false) && handler.getFluid() != null && handler.getFluid().getFluid() == FluidRegistry.WATER) {
                ItemStack stackinhand = playerIn.func_184586_b(hand);
                ItemStack out = new ItemStack(Blocks.field_192443_dR, 1, stackinhand.func_77952_i());
                playerIn.func_184586_b(hand).func_190918_g(1);
                if (!worldIn.field_72995_K) {
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, out));
                }
                return true;
            }
            if (!playerIn.func_70093_af()) {
                this.openGui(playerIn, (AdvancedTileEntity)worldIn.func_175625_s(pos));
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY, GuiContainer gui, int guiLeft, int guiTop) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY, gui, guiLeft, guiTop);
        int amount = 0;
        String name = "Empty";
        if (this.tank.getFluid() != null) {
            amount = this.tank.getFluidAmount();
            name = this.tank.getFluid().getFluid().getName();
        }
        this.getBuilder().drawString((GuiScreen)gui, "Quantum Tank", 56, 8);
        this.getBuilder().drawBigBlueBar((AdvancedGui)gui, 30, 50, amount, this.tank.getCapacity(), mouseX - guiLeft, mouseY - guiTop, "", "Fluid Type: " + name, amount + " mb " + name);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
    }

    @Override
    public Block getBlock() {
        return ModBlocks.TANK;
    }

    @Override
    public void addRecipe() {
        if (!ConfigQuantumStorage.disableQuantumTank) {
            RebornCraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.TANK), (Object[])new Object[]{"OOO", "IBI", "III", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z), Character.valueOf('B'), new ItemStack(Items.field_151133_ar)});
            RebornCraftingHelper.addShapelessRecipe((ItemStack)new ItemStack(ModBlocks.TANK), (Object[])new Object[]{new ItemStack(ModBlocks.TANK)});
        }
    }

    @Override
    public void writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
    }

    @Override
    public void readFromNBTWithoutCoords(NBTTagCompound compound) {
        this.tank.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_179237_a(this.tank.writeToNBT(compound));
        return compound;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return null;
    }

    public void func_73660_a() {
        this.sync();
        this.handleUpgrades();
        TileQuantumTank.pushFluid(this.field_145850_b, this.func_174877_v(), (IFluidHandler)this.tank, EnumFacing.UP, EnumFacing.DOWN);
    }

    public static FluidStack pushFluid(World world, BlockPos pos, IFluidHandler fluid, EnumFacing ... sides) {
        try {
            if (!world.field_72995_K) {
                for (EnumFacing side : sides) {
                    IFluidHandler other;
                    TileEntity tile = world.func_175625_s(pos.func_177972_a(side));
                    if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()) || (other = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) == null || tile instanceof TileQuantumTank) continue;
                    return fluid.drain(other.fill(fluid.drain(1000, false), true), true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void handleUpgrades() {
        if (this.getTileData().func_74764_b("infin_water") && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.canFill()) {
            this.tank.fill(this.tank.getFluid(), true);
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74775_l("tileEntity") != null) {
            String fluidname = stack.func_77978_p().func_74775_l("tileEntity").func_74779_i("FluidName");
            int fluidamount = stack.func_77978_p().func_74775_l("tileEntity").func_74762_e("Amount");
            if (fluidamount != 0) {
                tooltip.add(TextFormatting.GOLD + "Stored Fluid type: " + fluidamount + "mb " + fluidname);
            }
        }
    }
}

