/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.multiblock;

import QuantumStorage.inventory.CachingItemHandler;
import QuantumStorage.multiblock.BlockMultiStorage;
import QuantumStorage.multiblock.MultiBlockStorage;
import QuantumStorage.utils.SortingHandler;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraftforge.items.IItemHandler;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;

public class TileMultiStorage
extends RectangularMultiblockTileEntityBase {
    public CachingItemHandler inv;
    public Optional<Integer> page = Optional.empty();

    public void isGoodForFrame() throws MultiblockValidationException {
        if (!this.getVarient().equals("frame")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the frame of the block");
        }
    }

    public void isGoodForSides() throws MultiblockValidationException {
        if (!(this.getVarient().equals("heat") || this.getVarient().equals("io") || this.getVarient().equals("interface"))) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForTop() throws MultiblockValidationException {
        if (!(this.getVarient().equals("heat") || this.getVarient().equals("io") || this.getVarient().equals("interface"))) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForBottom() throws MultiblockValidationException {
        if (!this.getVarient().equals("heat")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the sides of the block");
        }
    }

    public void isGoodForInterior() throws MultiblockValidationException {
        if (!this.getVarient().equals("storage")) {
            throw new MultiblockValidationException(this.getVarient() + " is not valid for the inside of the block");
        }
    }

    public void onMachineActivated() {
        if (this.getMultiBlock() != null) {
            this.func_73660_a();
        }
    }

    public void onMachineDeactivated() {
    }

    String getVarient() {
        return (String)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMultiStorage.VARIANTS));
    }

    public MultiblockControllerBase createNewMultiblock() {
        return new MultiBlockStorage(this.func_145831_w());
    }

    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return MultiBlockStorage.class;
    }

    public MultiBlockStorage getMultiBlock() {
        return (MultiBlockStorage)this.getMultiblockController();
    }

    public TileMultiStorage(String varient) {
        if (varient.equals("storage")) {
            this.inv = new CachingItemHandler(78);
        }
    }

    public void onLoad() {
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (this.inv == null && data.func_74764_b("hasInv")) {
            this.inv = new CachingItemHandler(78);
        }
        if (this.inv != null) {
            this.inv.deserializeNBT(data);
        }
        if (data.func_74764_b("page")) {
            this.page = Optional.of(data.func_74762_e("page"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        if (this.inv != null) {
            data = super.func_189515_b(data);
            data.func_179237_a(this.inv.serializeNBT());
            data.func_74757_a("hasInv", true);
        }
        if (this.page.isPresent()) {
            data.func_74768_a("page", this.page.get().intValue());
        }
        return super.func_189515_b(data);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public TileMultiStorage() {
    }

    public void func_73660_a() {
    }

    public void actionPerformed(int iD) {
        if (iD == -1) {
            for (int i = 0; i < this.getMultiBlock().pages; ++i) {
                if (i == 0) continue;
                SortingHandler.sortInventory((IItemHandler)this.getMultiBlock().getInvForPage(i));
            }
        }
    }
}

