/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.multiblock;

import QuantumStorage.config.ConfigQuantumStorage;
import QuantumStorage.inventory.CachingItemHandler;
import QuantumStorage.multiblock.BlockMultiStorage;
import QuantumStorage.multiblock.TileMultiStorage;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockControllerBase;

public class MultiBlockStorage
extends RectangularMultiblockControllerBase {
    public Map<Integer, CachingItemHandler> invs = new TreeMap<Integer, CachingItemHandler>();
    public int pages = 0;
    int lie = 0;

    public MultiBlockStorage(World world) {
        super(world);
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart iMultiblockPart, NBTTagCompound nbtTagCompound) {
    }

    protected void onBlockAdded(IMultiblockPart iMultiblockPart) {
    }

    protected void onBlockRemoved(IMultiblockPart iMultiblockPart) {
    }

    protected void onMachineAssembled() {
        this.updateInfo();
    }

    protected void onMachineRestored() {
        this.updateInfo();
    }

    protected void onMachinePaused() {
    }

    public void updateInfo() {
        this.pages = 0;
        this.invs.clear();
        TreeMap<Integer, TileMultiStorage> collector = new TreeMap<Integer, TileMultiStorage>();
        int append = 2745;
        for (IMultiblockPart part : this.connectedParts) {
            if (!((String)((Object)part.getBlockState().func_177229_b((IProperty)BlockMultiStorage.VARIANTS))).equals("storage")) continue;
            ++this.pages;
            TileMultiStorage tile = (TileMultiStorage)part;
            if (tile.page.isPresent()) {
                collector.put(tile.page.get(), tile);
                continue;
            }
            collector.put(append++, tile);
        }
        int newid = 0;
        for (TileMultiStorage tile : collector.values()) {
            tile.page = Optional.of(++newid);
            this.invs.put(newid, tile.inv);
        }
        this.lie();
    }

    public CachingItemHandler getInvForPage(int page) {
        return this.invs.get(page);
    }

    public void lie() {
        for (int i = 0; i < this.pages; ++i) {
            if (i == 0 || this.getInvForPage(i).isFull()) continue;
            this.lie = i;
            break;
        }
    }

    public int getLie() {
        return this.lie;
    }

    protected void onMachineDisassembled() {
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 27;
    }

    protected int getMaximumXSize() {
        return ConfigQuantumStorage.multiblockMaxX;
    }

    protected int getMaximumZSize() {
        return ConfigQuantumStorage.multiblockMaxZ;
    }

    protected int getMaximumYSize() {
        return ConfigQuantumStorage.multiblockMaxY;
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected void onAssimilate(MultiblockControllerBase multiblockControllerBase) {
    }

    protected void onAssimilated(MultiblockControllerBase multiblockControllerBase) {
    }

    protected boolean updateServer() {
        return true;
    }

    protected void updateClient() {
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
    }

    public void formatDescriptionPacket(NBTTagCompound nbtTagCompound) {
        this.writeToNBT(nbtTagCompound);
    }

    public void decodeDescriptionPacket(NBTTagCompound nbtTagCompound) {
        this.readFromNBT(nbtTagCompound);
    }
}

