/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.util.helper.CommonRegisterHelper;
import stevekung.mods.moreplanets.util.items.EnumSortCategoryItem;
import stevekung.mods.moreplanets.util.items.ISortableItem;

public class ItemElectricHoeMP
extends ItemHoe
implements IItemElectric,
ISortableItem {
    public float transferMax = 200.0f;
    private float maxPower;

    public ItemElectricHoeMP(String name, Item.ToolMaterial material, float maxPower) {
        super(material);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77655_b(name);
        this.maxPower = maxPower;
    }

    public float getMaxElectricityStored(ItemStack itemStack) {
        return this.maxPower;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase living, EntityLivingBase holder) {
        if (this.getElectricityStored(itemStack) > 0.0f) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.0f);
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.getElectricityStored(itemStack) > 0.0f) {
            if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
                return EnumActionResult.FAIL;
            }
            int hook = ForgeEventFactory.onHoeUse((ItemStack)itemStack, (EntityPlayer)player, (World)world, (BlockPos)pos);
            IBlockState iblockstate = world.func_180495_p(pos);
            Block block = iblockstate.func_177230_c();
            if (hook != 0) {
                return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            if (facing != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
                if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                    this.func_185071_a(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                    return EnumActionResult.SUCCESS;
                }
                if (block == Blocks.field_150346_d) {
                    switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                        default: {
                            this.func_185071_a(itemStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                            return EnumActionResult.SUCCESS;
                        }
                        case COARSE_DIRT: 
                    }
                    this.func_185071_a(itemStack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                    return EnumActionResult.SUCCESS;
                }
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    protected void func_185071_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_180501_a(pos, state, 11);
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.0f);
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack itemStack) {
        return this.getElectricityStored(itemStack) > 0.0f ? super.getAttributeModifiers(slot, itemStack) : HashMultimap.create();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        TextFormatting color = null;
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? TextFormatting.DARK_RED : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? TextFormatting.DARK_GREEN : TextFormatting.GOLD);
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.setElectricity(itemStack, 0.0f);
    }

    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("Electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("Electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("Electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (CommonRegisterHelper.isItemTab(creativeTabs)) {
            list.add((Object)ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
        }
    }

    public CreativeTabs func_77640_w() {
        return MorePlanetsCore.ITEM_TAB;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public EnumSortCategoryItem getItemCategory(int meta) {
        return EnumSortCategoryItem.HOE;
    }
}

