/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.util.blocks.BlockBushMP;

public class BlockStemMP
extends BlockBushMP
implements IGrowable {
    public static PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", facing -> facing != EnumFacing.DOWN);
    private Block crop;
    protected static AxisAlignedBB[] STEM_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.875, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625)};

    public BlockStemMP(String name, Block crop) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.crop = crop;
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.setSoundType(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return STEM_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this.crop) continue;
            state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
            break;
        }
        return state;
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == NibiruBlocks.INFECTED_FARMLAND;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float f;
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt((int)(25.0f / (f = this.getGrowthChance(this, world, pos, state))) + 1) == 0) {
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            if (i < 7) {
                state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1));
                world.func_180501_a(pos, state, 2);
            } else {
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    if (world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this.crop) continue;
                    return;
                }
                pos = pos.func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
                Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
                if (world.func_175623_d(pos) && (block == NibiruBlocks.INFECTED_GRASS || block == NibiruBlocks.INFECTED_DIRT || block == NibiruBlocks.INFECTED_FARMLAND)) {
                    world.func_175656_a(pos, this.crop.func_176223_P());
                }
            }
        }
    }

    protected float getGrowthChance(Block block, World world, BlockPos pos, IBlockState state) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = world.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (this.canBlockStay(world, blockpos.func_177982_a(i, 0, j), state)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(world, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = block == world.func_180495_p(blockpos3).func_177230_c() || block == world.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = block == world.func_180495_p(blockpos1).func_177230_c() || block == world.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = block == world.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || block == world.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || block == world.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public void growStem(World world, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
        world.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.min(7, i))), 2);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.getSeedItem();
        if (item != null) {
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            for (int j = 0; j < 3; ++j) {
                if (RANDOM.nextInt(15) > i) continue;
                ret.add(new ItemStack(item));
            }
        }
        return ret;
    }

    protected Item getSeedItem() {
        return this.crop == NibiruBlocks.INFECTED_MELON_BLOCK ? NibiruItems.INFECTED_MELON_SEEDS : null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) != 7;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(NibiruItems.INFECTED_MELON_SEEDS);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.growStem(world, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, FACING});
    }
}

