/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.util.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.util.blocks.BlockContainerMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.ISingleBlockRender;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;
import stevekung.mods.moreplanets.util.tileentity.TileEntityChestMP;

public abstract class BlockChestMP
extends BlockContainerMP
implements ISingleBlockRender {
    protected static AxisAlignedBB NORTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    protected static AxisAlignedBB SOUTH_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    protected static AxisAlignedBB WEST_CHEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    protected static AxisAlignedBB EAST_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);
    protected static AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    protected BlockChestMP() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
        this.func_149752_b(5.0f);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177978_c()).func_177230_c() == this ? NORTH_CHEST_AABB : (world.func_180495_p(pos.func_177968_d()).func_177230_c() == this ? SOUTH_CHEST_AABB : (world.func_180495_p(pos.func_177976_e()).func_177230_c() == this ? WEST_CHEST_AABB : (world.func_180495_p(pos.func_177974_f()).func_177230_c() == this ? EAST_CHEST_AABB : NOT_CONNECTED_AABB)));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.checkForSurroundingChests(world, pos, state);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            IBlockState iblockstate = world.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) continue;
            this.checkForSurroundingChests(world, blockpos, iblockstate);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity tileentity;
        boolean flag3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing);
        BlockPos blockpos = pos.func_177978_c();
        BlockPos blockpos1 = pos.func_177968_d();
        BlockPos blockpos2 = pos.func_177976_e();
        BlockPos blockpos3 = pos.func_177974_f();
        boolean flag = this == world.func_180495_p(blockpos).func_177230_c();
        boolean flag1 = this == world.func_180495_p(blockpos1).func_177230_c();
        boolean flag2 = this == world.func_180495_p(blockpos2).func_177230_c();
        boolean bl = flag3 = this == world.func_180495_p(blockpos3).func_177230_c();
        if (!(flag || flag1 || flag2 || flag3)) {
            world.func_180501_a(pos, state, 3);
        } else if (enumfacing.func_176740_k() != EnumFacing.Axis.X || !flag && !flag1) {
            if (enumfacing.func_176740_k() == EnumFacing.Axis.Z && (flag2 || flag3)) {
                if (flag2) {
                    world.func_180501_a(blockpos2, state, 3);
                } else {
                    world.func_180501_a(blockpos3, state, 3);
                }
                world.func_180501_a(pos, state, 3);
            }
        } else {
            if (flag) {
                world.func_180501_a(blockpos, state, 3);
            } else {
                world.func_180501_a(blockpos1, state, 3);
            }
            world.func_180501_a(pos, state, 3);
        }
        if (itemStack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityChestMP) {
            ((TileEntityChestMP)tileentity).func_190575_a(itemStack.func_82833_r());
        }
    }

    public IBlockState checkForSurroundingChests(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return state;
        }
        IBlockState iblockstate = world.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate1 = world.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate2 = world.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate3 = world.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
        Block block = iblockstate.func_177230_c();
        Block block1 = iblockstate1.func_177230_c();
        Block block2 = iblockstate2.func_177230_c();
        Block block3 = iblockstate3.func_177230_c();
        if (block != this && block1 != this) {
            boolean flag = iblockstate.func_185913_b();
            boolean flag1 = iblockstate1.func_185913_b();
            if (block2 == this || block3 == this) {
                BlockPos blockpos1 = block2 == this ? pos.func_177976_e() : pos.func_177974_f();
                IBlockState iblockstate6 = world.func_180495_p(blockpos1.func_177978_c());
                IBlockState iblockstate7 = world.func_180495_p(blockpos1.func_177968_d());
                enumfacing = EnumFacing.SOUTH;
                EnumFacing enumfacing2 = block2 == this ? (EnumFacing)iblockstate2.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON) : (EnumFacing)iblockstate3.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
                if (enumfacing2 == EnumFacing.NORTH) {
                    enumfacing = EnumFacing.NORTH;
                }
                if ((flag || iblockstate6.func_185913_b()) && !flag1 && !iblockstate7.func_185913_b()) {
                    enumfacing = EnumFacing.SOUTH;
                }
                if ((flag1 || iblockstate7.func_185913_b()) && !flag && !iblockstate6.func_185913_b()) {
                    enumfacing = EnumFacing.NORTH;
                }
            }
        } else {
            BlockPos blockpos = block == this ? pos.func_177978_c() : pos.func_177968_d();
            IBlockState iblockstate4 = world.func_180495_p(blockpos.func_177976_e());
            IBlockState iblockstate5 = world.func_180495_p(blockpos.func_177974_f());
            enumfacing = EnumFacing.EAST;
            EnumFacing enumfacing1 = block == this ? (EnumFacing)iblockstate.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON) : (EnumFacing)iblockstate1.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
            if (enumfacing1 == EnumFacing.WEST) {
                enumfacing = EnumFacing.WEST;
            }
            if ((iblockstate2.func_185913_b() || iblockstate4.func_185913_b()) && !iblockstate3.func_185913_b() && !iblockstate5.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            }
            if ((iblockstate3.func_185913_b() || iblockstate5.func_185913_b()) && !iblockstate2.func_185913_b() && !iblockstate4.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
        }
        state = state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing);
        world.func_180501_a(pos, state, 3);
        return state;
    }

    public IBlockState correctFacing(World world, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = null;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(enumfacing1));
            if (iblockstate.func_177230_c() == this) {
                return state;
            }
            if (!iblockstate.func_185913_b()) continue;
            if (enumfacing != null) {
                enumfacing = null;
                break;
            }
            enumfacing = enumfacing1;
        }
        if (enumfacing != null) {
            return state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
        if (world.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if (world.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if (world.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing2);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        int i = 0;
        BlockPos blockpos = pos.func_177976_e();
        BlockPos blockpos1 = pos.func_177974_f();
        BlockPos blockpos2 = pos.func_177978_c();
        BlockPos blockpos3 = pos.func_177968_d();
        if (world.func_180495_p(blockpos).func_177230_c() == this) {
            if (this.isDoubleChest(world, blockpos)) {
                return false;
            }
            ++i;
        }
        if (world.func_180495_p(blockpos1).func_177230_c() == this) {
            if (this.isDoubleChest(world, blockpos1)) {
                return false;
            }
            ++i;
        }
        if (world.func_180495_p(blockpos2).func_177230_c() == this) {
            if (this.isDoubleChest(world, blockpos2)) {
                return false;
            }
            ++i;
        }
        if (world.func_180495_p(blockpos3).func_177230_c() == this) {
            if (this.isDoubleChest(world, blockpos3)) {
                return false;
            }
            ++i;
        }
        return i <= 1;
    }

    private boolean isDoubleChest(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return false;
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (world.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) continue;
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ILockableContainer ilockablecontainer = this.getLockableContainer(world, pos);
        if (ilockablecontainer != null) {
            player.func_71007_a((IInventory)ilockablecontainer);
            player.func_71029_a(StatList.field_188063_ac);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.getChestTile();
    }

    protected boolean isBlocked(World world, BlockPos pos) {
        return this.isBelowSolidBlock(world, pos);
    }

    private boolean isBelowSolidBlock(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN, false);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(world, pos));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateHelper.FACING_HORIZON});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.CHEST;
    }

    protected abstract ILockableContainer getLockableContainer(World var1, BlockPos var2);

    protected abstract TileEntity getChestTile();
}

