/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.StructureNibiruJungleTemplePieces;
import stevekung.mods.moreplanets.util.MPLog;

public class MapGenNibiruJungleTemple
extends MapGenStructure {
    private List<Biome.SpawnListEntry> scatteredFeatureSpawnList = new ArrayList<Biome.SpawnListEntry>();
    private int maxDistanceBetweenScatteredFeatures = 32;
    private int minDistanceBetweenScatteredFeatures = 8;

    public MapGenNibiruJungleTemple() {
        this.scatteredFeatureSpawnList.add(new Biome.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    public MapGenNibiruJungleTemple(Map<String, String> map) {
        this();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().equals("distance")) continue;
            this.maxDistanceBetweenScatteredFeatures = MathHelper.func_82714_a((String)entry.getValue(), (int)this.maxDistanceBetweenScatteredFeatures, (int)(this.minDistanceBetweenScatteredFeatures + 1));
        }
    }

    public String func_143025_a() {
        return "NibiruJungleTemple";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int k = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int l = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(k, l, 14357617);
        k *= this.maxDistanceBetweenScatteredFeatures;
        l *= this.maxDistanceBetweenScatteredFeatures;
        if (i == (k += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && j == (l += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures))) {
            Biome biomegenbase = this.field_75039_c.func_72959_q().func_180631_a(new BlockPos(i * 16 + 8, 0, j * 16 + 8));
            if (biomegenbase == null) {
                return false;
            }
            if (biomegenbase == MPBiomes.INFECTED_JUNGLE) {
                return true;
            }
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public BlockPos func_180706_b(World world, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenStructure.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenScatteredFeatures, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)findUnexplored);
    }

    public boolean canMobSpawn(BlockPos pos) {
        StructureStart structurestart = this.func_175797_c(pos);
        if (structurestart != null && structurestart instanceof Start && !structurestart.func_186161_c().isEmpty()) {
            StructureComponent structurecomponent = (StructureComponent)structurestart.func_186161_c().get(0);
            return structurecomponent instanceof StructureNibiruJungleTemplePieces.JungleTemple;
        }
        return false;
    }

    public List<Biome.SpawnListEntry> getSpawnList() {
        return this.scatteredFeatureSpawnList;
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"NibiruJungleTemple");
        MapGenStructureIO.func_143031_a(StructureNibiruJungleTemplePieces.JungleTemple.class, (String)"NibiruJungleTemple");
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            MPLog.debug("Generate jungle temple at x:{} z:{}", chunkX * 16, chunkZ * 16);
            Biome biomegenbase = world.func_180494_b(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8));
            if (biomegenbase == MPBiomes.INFECTED_JUNGLE) {
                StructureNibiruJungleTemplePieces.JungleTemple component = new StructureNibiruJungleTemplePieces.JungleTemple(rand, chunkX * 16, chunkZ * 16);
                this.field_75075_a.add(component);
            }
            this.func_75072_c();
        }
    }
}

