/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.world.gen;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.BiomeDecoratorNibiruOre;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.MapGenNibiruCaves;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.MapGenNibiruRavine;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.MapGenNibiruDungeon;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.RoomBossNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.RoomChestNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.RoomSpawnerNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.dungeon.RoomTreasureNibiru;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.MapGenNibiruJungleTemple;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.MapGenNibiruMineshaft;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.MapGenNibiruOceanMonument;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.MapGenNibiruPyramid;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.MapGenNibiruStronghold;
import stevekung.mods.moreplanets.module.planets.nibiru.world.gen.structure.MapGenNibiruVillage;
import stevekung.mods.moreplanets.util.world.gen.dungeon.DungeonConfigurationMP;
import stevekung.mods.moreplanets.util.world.gen.feature.WorldGenLiquidLakes;
import stevekung.mods.moreplanets.util.world.gen.feature.WorldGenSpaceDungeons;

public class ChunkGeneratorNibiru
implements IChunkGenerator {
    private Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorOctaves forestNoise;
    private World worldObj;
    private double[] heightMap;
    private float[] parabolicField;
    private double[] depthBuffer = new double[256];
    private MapGenBase caveGenerator = new MapGenNibiruCaves();
    private MapGenNibiruStronghold strongholdGenerator = new MapGenNibiruStronghold();
    private MapGenNibiruVillage villageGenerator = new MapGenNibiruVillage();
    private MapGenNibiruMineshaft mineshaftGenerator = new MapGenNibiruMineshaft();
    private MapGenNibiruPyramid pyramidGenerator = new MapGenNibiruPyramid();
    private MapGenNibiruJungleTemple jungleTempleGenerator = new MapGenNibiruJungleTemple();
    private MapGenBase ravineGenerator = new MapGenNibiruRavine();
    private MapGenNibiruOceanMonument oceanMonumentGenerator = new MapGenNibiruOceanMonument();
    public BiomeDecoratorNibiruOre biomedecoratorplanet = new BiomeDecoratorNibiruOre();
    private MapGenNibiruDungeon dungeonGenerator = new MapGenNibiruDungeon(new DungeonConfigurationMP(NibiruBlocks.NIBIRU_BLOCK.func_176223_P().func_177226_a(BlockNibiru.VARIANT, (Comparable)((Object)BlockNibiru.BlockType.NIBIRU_DUNGEON_BRICK)), MPBlocks.DUNGEON_GLOWSTONE.func_176223_P(), Blocks.field_150321_G.func_176223_P(), NibiruBlocks.INFECTED_TORCH.func_176223_P(), NibiruBlocks.NIBIRU_ANCIENT_CHEST.func_176223_P(), 30, 8, 16, 7, 7, RoomBossNibiru.class, RoomTreasureNibiru.class, RoomSpawnerNibiru.class, RoomChestNibiru.class));
    private Biome[] biomesForGeneration;
    double[] mainNoiseRegion;
    double[] minLimitRegion;
    double[] maxLimitRegion;
    double[] depthRegion;

    public ChunkGeneratorNibiru(World world, long seed) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.forestNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.heightMap = new double[825];
        this.parabolicField = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.parabolicField[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, this.scaleNoise, this.depthNoise, this.forestNoise};
        this.minLimitPerlinNoise = (NoiseGeneratorOctaves)noiseGens[0];
        this.maxLimitPerlinNoise = (NoiseGeneratorOctaves)noiseGens[1];
        this.mainPerlinNoise = (NoiseGeneratorOctaves)noiseGens[2];
        this.surfaceNoise = (NoiseGeneratorPerlin)noiseGens[3];
        this.scaleNoise = (NoiseGeneratorOctaves)noiseGens[4];
        this.depthNoise = (NoiseGeneratorOctaves)noiseGens[5];
        this.forestNoise = (NoiseGeneratorOctaves)noiseGens[6];
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[i1 + i2];
                    double d2 = this.heightMap[j1 + i2];
                    double d3 = this.heightMap[k1 + i2];
                    double d4 = this.heightMap[l1 + i2];
                    double d5 = (this.heightMap[i1 + i2 + 1] - d1) * d0;
                    double d6 = (this.heightMap[j1 + i2 + 1] - d2) * d0;
                    double d7 = (this.heightMap[k1 + i2 + 1] - d3) * d0;
                    double d8 = (this.heightMap[l1 + i2 + 1] - d4) * d0;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (d > 0.0) {
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, NibiruBlocks.NIBIRU_BLOCK.func_176223_P());
                                    continue;
                                }
                                if (i2 * 8 + j2 >= 63) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, NibiruBlocks.INFECTED_WATER_FLUID_BLOCK.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer chunkPrimer, Biome[] biome) {
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biomegenbase = biome[j + i * 16];
                biomegenbase.func_180622_a(this.worldObj, this.rand, chunkPrimer, chunkX * 16 + i, chunkZ * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(chunkX, chunkZ, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.replaceBlocksForBiome(chunkX, chunkZ, chunkprimer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.ravineGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.mineshaftGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.strongholdGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.pyramidGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.jungleTempleGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.oceanMonumentGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.villageGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        this.dungeonGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, chunkprimer);
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, chunkX, chunkZ);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateHeightmap(int chunkX, int chunkY, int chunkZ) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX, chunkZ, 5, 5, 200.0, 200.0, 0.5);
        float f = 684.412f;
        float f1 = 684.412f;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX, chunkY, chunkZ, 5, 33, 5, (double)(f / 80.0f), (double)(f1 / 160.0f), (double)(f / 80.0f));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX, chunkY, chunkZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX, chunkY, chunkZ, 5, 33, 5, (double)f, (double)f1, (double)f);
        chunkZ = 0;
        chunkX = 0;
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biomegenbase = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -i1; j1 <= i1; ++j1) {
                    for (int k1 = -i1; k1 <= i1; ++k1) {
                        Biome biomegenbase1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = 0.0f + biomegenbase1.func_185355_j() * 1.0f;
                        float f6 = 0.0f + biomegenbase1.func_185360_m() * 1.0f;
                        float f7 = this.parabolicField[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.depthRegion[j] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * 8.5 / 8.0;
                double d0 = 8.5 + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = this.minLimitRegion[i] / 512.0;
                    double d3 = this.maxLimitRegion[i] / 512.0;
                    double d4 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151237_a((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.heightMap[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos blockpos = new BlockPos(x, 0, z);
        Biome biomegenbase = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.worldObj.func_72905_C());
        ChunkPos chunkcoordintpair = new ChunkPos(chunkX, chunkZ);
        this.biomedecoratorplanet.func_180292_a(this.worldObj, this.rand, biomegenbase, blockpos);
        this.mineshaftGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        this.strongholdGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        this.pyramidGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        this.jungleTempleGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        this.villageGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        this.dungeonGenerator.func_175794_a(this.worldObj, this.rand, chunkcoordintpair);
        if (biomegenbase != MPBiomes.INFECTED_OCEAN && biomegenbase != MPBiomes.INFECTED_DEEP_OCEAN && biomegenbase != MPBiomes.INFECTED_RIVER) {
            int worldX = chunkX << 4;
            int worldZ = chunkZ << 4;
            this.generateGas(this.worldObj, this.rand, worldX + 15, worldZ + 15);
            this.generateOil(this.worldObj, this.rand, worldX + 15, worldZ + 15);
        }
        if (biomegenbase != MPBiomes.INFECTED_DESERT && biomegenbase != MPBiomes.GREEN_VEIN && this.rand.nextInt(4) == 0) {
            new WorldGenLiquidLakes(NibiruBlocks.INFECTED_WATER_FLUID_BLOCK, NibiruBlocks.NIBIRU_BLOCK, 0, false).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (biomegenbase == MPBiomes.GREEN_VEIN && this.rand.nextInt(6) == 0) {
            new WorldGenLiquidLakes(NibiruBlocks.PURIFY_WATER_FLUID_BLOCK, NibiruBlocks.TERRASTONE, 0, true).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        if (this.rand.nextInt(8) == 0 && ((y = this.rand.nextInt(this.rand.nextInt(248) + 8)) < 63 || this.rand.nextInt(10) == 0)) {
            new WorldGenLiquidLakes((Block)Blocks.field_150353_l, NibiruBlocks.NIBIRU_BLOCK, 0, true).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, y, this.rand.nextInt(16) + 8));
        }
        for (int i = 0; i < 8; ++i) {
            new WorldGenSpaceDungeons(NibiruBlocks.NIBIRU_ANCIENT_CHEST, NibiruBlocks.NIBIRU_BLOCK, NibiruBlocks.NIBIRU_BLOCK, 1, 2).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
        }
        biomegenbase.func_180624_a(this.worldObj, this.rand, blockpos);
        WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biomegenbase, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        blockpos = blockpos.func_177982_a(8, 0, 8);
        for (int snowX = 0; snowX < 16; ++snowX) {
            for (int snowZ = 0; snowZ < 16; ++snowZ) {
                BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(snowX, 0, snowZ));
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (this.worldObj.func_175675_v(blockpos2)) {
                    this.worldObj.func_180501_a(blockpos2, NibiruBlocks.INFECTED_ICE.func_176223_P(), 2);
                }
                if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                this.worldObj.func_180501_a(blockpos1, NibiruBlocks.INFECTED_SNOW_LAYER.func_176223_P(), 2);
            }
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunk, int chunkX, int chunkZ) {
        boolean flag = false;
        if (chunk.func_177416_w() < 3600L) {
            flag |= this.oceanMonumentGenerator.func_175794_a(this.worldObj, this.rand, new ChunkPos(chunkX, chunkZ));
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType type, BlockPos pos) {
        if (type == EnumCreatureType.MONSTER) {
            if (this.pyramidGenerator.canMobSpawn(pos)) {
                return this.pyramidGenerator.getSpawnList();
            }
            if (this.jungleTempleGenerator.canMobSpawn(pos)) {
                return this.jungleTempleGenerator.getSpawnList();
            }
            if (this.oceanMonumentGenerator.func_175796_a(this.worldObj, pos)) {
                return this.oceanMonumentGenerator.getSpawnList();
            }
        }
        return this.worldObj.func_180494_b(pos).func_76747_a(type);
    }

    public BlockPos func_180513_a(World world, String structureName, BlockPos position, boolean findUnexplored) {
        return "NibiruStronghold".equals(structureName) && this.strongholdGenerator != null ? this.strongholdGenerator.func_180706_b(world, position, false) : null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunk, int chunkX, int chunkZ) {
        this.mineshaftGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
        this.strongholdGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
        this.pyramidGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
        this.jungleTempleGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
        this.oceanMonumentGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
        this.villageGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
        this.dungeonGenerator.func_186125_a(this.worldObj, chunkX, chunkZ, null);
    }

    private void generateGas(World world, Random rand, int xx, int zz) {
        BlockVec3 pos = new BlockVec3();
        if (this.gasPresent(world, rand, xx, zz, pos)) {
            int x = pos.x;
            int cy = pos.y;
            int z = pos.z;
            int r = 2 + rand.nextInt(2);
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r + 2; by <= r - 2; ++by) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by * by * 3 + bz * bz;
                        if (d2 > r2 || this.checkBlockGas(world, bx + x - 1, by + cy, bz + z) || this.checkBlockGas(world, bx + x + 1, by + cy, bz + z) || this.checkBlockGas(world, bx + x, by + cy - 1, bz + z) || this.checkBlockGas(world, bx + x, by + cy, bz + z - 1) || this.checkBlockGas(world, bx + x, by + cy, bz + z + 1)) continue;
                        world.func_180501_a(new BlockPos(bx + x, by + cy, bz + z), NibiruBlocks.HELIUM_GAS_BLOCK.func_176223_P(), 2);
                    }
                }
            }
        }
    }

    private boolean gasPresent(World world, Random rand, int x, int z, BlockVec3 pos) {
        boolean flag2;
        rand.setSeed(world.func_72905_C());
        long i1 = (long)rand.nextInt() / 2L * 2L + 1L;
        long j1 = (long)rand.nextInt() / 2L * 2L + 1L;
        rand.setSeed((long)x * i1 + (long)z * j1 ^ world.func_72905_C());
        double randMod = Math.min(0.2, 0.08);
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            pos.y = 32 + rand.nextInt(10) + rand.nextInt(5);
            pos.x = x + 8 - rand.nextInt(16);
            pos.z = z + 8 - rand.nextInt(16);
            return true;
        }
        return false;
    }

    private boolean checkBlockGas(World world, int x, int y, int z) {
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151579_a) {
            return true;
        }
        return block instanceof BlockLiquid && block != NibiruBlocks.HELIUM_GAS_BLOCK;
    }

    private void generateOil(World world, Random rand, int xx, int zz) {
        BlockVec3 pos = new BlockVec3();
        if (this.oilPresent(world, rand, xx, zz, pos)) {
            int x = pos.x;
            int cy = pos.y;
            int z = pos.z;
            int r = 3 + rand.nextInt(5);
            int r2 = r * r;
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r + 2; by <= r - 2; ++by) {
                    for (int bz = -r; bz <= r; ++bz) {
                        int d2 = bx * bx + by * by * 3 + bz * bz;
                        if (d2 > r2 || this.checkBlockOil(world, bx + x - 1, by + cy, bz + z) || this.checkBlockOil(world, bx + x + 1, by + cy, bz + z) || this.checkBlockOil(world, bx + x, by + cy - 1, bz + z) || this.checkBlockOil(world, bx + x, by + cy, bz + z - 1) || this.checkBlockOil(world, bx + x, by + cy, bz + z + 1)) continue;
                        world.func_180501_a(new BlockPos(bx + x, by + cy, bz + z), GCBlocks.crudeOil.func_176223_P(), 2);
                    }
                }
            }
        }
    }

    private boolean oilPresent(World world, Random rand, int x, int z, BlockVec3 pos) {
        boolean flag2;
        rand.setSeed(world.func_72905_C());
        long i1 = (long)rand.nextInt() / 2L * 2L + 1L;
        long j1 = (long)rand.nextInt() / 2L * 2L + 1L;
        rand.setSeed((long)x * i1 + (long)z * j1 ^ world.func_72905_C());
        double randMod = Math.min(0.2, 0.08);
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            pos.y = 17 + rand.nextInt(10) + rand.nextInt(5);
            pos.x = x + 8 - rand.nextInt(16);
            pos.z = z + 8 - rand.nextInt(16);
            return true;
        }
        return false;
    }

    private boolean checkBlockOil(World world, int x, int y, int z) {
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (world.func_180495_p(new BlockPos(x, y, z)).func_185904_a() == Material.field_151579_a) {
            return true;
        }
        return block instanceof BlockLiquid && block != GCBlocks.crudeOil;
    }
}

