/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.client.sky;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;
import stevekung.mods.moreplanets.init.MPBiomes;

public class WeatherRendererNibiru
extends IRenderHandler {
    private ResourceLocation rainTexture = new ResourceLocation("moreplanets:textures/environment/infected_rain.png");
    private ResourceLocation purifyRainTexture = new ResourceLocation("moreplanets:textures/environment/purify_rain.png");
    private ResourceLocation snowTexture = new ResourceLocation("moreplanets:textures/environment/infected_snow.png");
    private float[] rainXCoords = new float[1024];
    private float[] rainYCoords = new float[1024];
    private int rendererUpdateCount;
    private int rainSoundCounter;
    private Random random = new Random();
    public static WeatherRendererNibiru INSTANCE = new WeatherRendererNibiru();

    public WeatherRendererNibiru() {
        INSTANCE = this;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(float partialTicks, WorldClient worldClient, Minecraft mc) {
        float f;
        if (mc.field_71439_g.field_70163_u > 256.0) {
            return;
        }
        if (this.rendererUpdateCount == -1) {
            this.addRainParticles(mc);
        }
        if ((f = mc.field_71441_e.func_72867_j(partialTicks)) > 0.0f) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            worldrenderer.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainXCoords[i2] * 0.5;
                    double d4 = (double)this.rainYCoords[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biomegenbase = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (!biomegenbase.func_76738_d() && !biomegenbase.func_76746_c()) continue;
                    int j2 = world.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biomegenbase.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (world.func_72959_q().func_76939_a(f2, j2) >= 0.15f) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            if (biomegenbase == MPBiomes.GREEN_VEIN) {
                                mc.func_110434_K().func_110577_a(this.purifyRainTexture);
                            } else {
                                mc.func_110434_K().func_110577_a(this.rainTexture);
                            }
                            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = ((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        worldrenderer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        worldrenderer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        worldrenderer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        worldrenderer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        mc.func_110434_K().func_110577_a(this.snowTexture);
                        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                    double d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    worldrenderer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    worldrenderer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    worldrenderer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    worldrenderer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            worldrenderer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private void addRainParticles(Minecraft mc) {
        float f = mc.field_71441_e.func_72867_j(1.0f);
        if (!mc.field_71474_y.field_74347_j) {
            f /= 2.0f;
        }
        if (f != 0.0f) {
            this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            BlockPos blockpos = new BlockPos(entity);
            int i = 10;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            int j = 0;
            int k = (int)(100.0f * f * f);
            if (mc.field_71474_y.field_74362_aa == 1) {
                k >>= 1;
            } else if (mc.field_71474_y.field_74362_aa == 2) {
                k = 0;
            }
            for (int l = 0; l < k; ++l) {
                BlockPos blockpos1 = world.func_175725_q(blockpos.func_177982_a(this.random.nextInt(i) - this.random.nextInt(i), 0, this.random.nextInt(i) - this.random.nextInt(i)));
                Biome biomegenbase = world.func_180494_b(blockpos1);
                BlockPos blockpos2 = blockpos1.func_177977_b();
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + i || blockpos1.func_177956_o() < blockpos.func_177956_o() - i || !biomegenbase.func_76738_d() || !(biomegenbase.func_180626_a(blockpos1) >= 0.15f)) continue;
                double d3 = this.random.nextDouble();
                double d4 = this.random.nextDouble();
                AxisAlignedBB axisalignedbb = world.func_180495_p(blockpos2).func_185900_c((IBlockAccess)world, blockpos2);
                if (world.func_180495_p(blockpos2).func_185904_a() == Material.field_151587_i) {
                    mc.field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)blockpos1.func_177958_n() + d3, (double)((float)blockpos1.func_177956_o() + 0.1f) - axisalignedbb.field_72338_b, (double)blockpos1.func_177952_p() + d4, 0.0, 0.0, 0.0, new int[0]);
                    continue;
                }
                if (world.func_180495_p(blockpos2).func_185904_a() == Material.field_151579_a || this.random.nextInt(++j) != 0) continue;
                d0 = (double)blockpos2.func_177958_n() + d3;
                d1 = (double)((float)blockpos2.func_177956_o() + 0.1f) + axisalignedbb.field_72337_e - 1.0;
                d2 = (double)blockpos2.func_177952_p() + d4;
            }
            if (j > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
                this.rainSoundCounter = 0;
                if (d1 > (double)(blockpos.func_177956_o() + 1) && world.func_175725_q(blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    mc.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    mc.field_71441_e.func_184134_a(d0, d1, d2, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    public void runRenderTick() {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_147113_T() && mc.field_71441_e != null) {
            this.rendererUpdateCount = mc.field_71441_e.func_72911_I() ? (this.rendererUpdateCount += 3) : ++this.rendererUpdateCount;
        }
    }
}

