/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.tileentity.TileEntityNibiruFurnace;
import stevekung.mods.moreplanets.util.blocks.BlockContainerMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.ISingleBlockRender;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;

public class BlockNibiruFurnace
extends BlockContainerMP
implements ISingleBlockRender {
    private boolean isBurning;
    private static boolean keepInventory;

    protected BlockNibiruFurnace(String name, boolean isBurning) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(name);
        this.func_149711_c(3.5f);
        this.isBurning = isBurning;
        if (this.isBurning) {
            this.func_149715_a(0.875f);
        }
    }

    @Override
    public CreativeTabs func_149708_J() {
        return !this.isBurning ? MorePlanetsCore.BLOCK_TAB : null;
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)NibiruBlocks.NIBIRU_FURNACE);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState block = world.func_180495_p(pos.func_177978_c());
            IBlockState block1 = world.func_180495_p(pos.func_177968_d());
            IBlockState block2 = world.func_180495_p(pos.func_177976_e());
            IBlockState block3 = world.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isBurning) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityNibiruFurnace) {
            player.func_71007_a((IInventory)((TileEntityNibiruFurnace)tileentity));
        }
        return true;
    }

    public static void setState(boolean active, World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            world.func_180501_a(pos, NibiruBlocks.NIBIRU_LIT_FURNACE.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, iblockstate.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)), 3);
            world.func_180501_a(pos, NibiruBlocks.NIBIRU_LIT_FURNACE.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, iblockstate.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)), 3);
        } else {
            world.func_180501_a(pos, NibiruBlocks.NIBIRU_FURNACE.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, iblockstate.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)), 3);
            world.func_180501_a(pos, NibiruBlocks.NIBIRU_FURNACE.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, iblockstate.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityNibiruFurnace();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity tileentity;
        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (itemStack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityNibiruFurnace) {
            ((TileEntityNibiruFurnace)tileentity).func_145951_a(itemStack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = world.func_175625_s(pos)) instanceof TileEntityNibiruFurnace) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityNibiruFurnace)tileentity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(NibiruBlocks.NIBIRU_FURNACE);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateHelper.FACING_HORIZON});
    }

    @Override
    public String getName() {
        return "nibiru_furnace";
    }
}

