/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.nibiru.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.util.VariantsName;
import stevekung.mods.moreplanets.util.blocks.BlockBaseMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockVariants;
import stevekung.mods.moreplanets.util.inventory.ContainerWorkbenchMP;

public class BlockNibiruCraftingTable
extends BlockBaseMP
implements IBlockVariants {
    public static PropertyEnum<BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockType.class);

    protected BlockNibiruCraftingTable(String name) {
        super(Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.setSoundType(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.NIBIRU_CRAFTING_TABLE)));
        this.func_149663_c(name);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.func_180468_a((IInteractionObject)new InterfaceCraftingTable(world, pos));
            return true;
        }
        return true;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int i = 0; i < BlockType.valuesCached().length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public VariantsName getVariantsName() {
        return new VariantsName("nibiru", "alien_berry");
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION_BLOCK;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)BlockType.valuesCached()[meta % BlockType.valuesCached().length]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public static enum BlockType implements IStringSerializable
    {
        NIBIRU_CRAFTING_TABLE,
        ALIEN_BERRY_CRAFTING_TABLE;

        private static BlockType[] values;

        public static BlockType[] valuesCached() {
            return values;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            values = BlockType.values();
        }
    }

    public static class InterfaceCraftingTable
    implements IInteractionObject {
        private World world;
        private BlockPos position;

        public InterfaceCraftingTable(World world, BlockPos pos) {
            this.world = world;
            this.position = pos;
        }

        public String func_70005_c_() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return null;
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
            return new ContainerWorkbenchMP(playerInventory, this.world, this.position, NibiruBlocks.NIBIRU_CRAFTING_TABLE);
        }

        public String func_174875_k() {
            return "minecraft:crafting_table";
        }
    }
}

