/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.entity;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.init.MPSounds;
import stevekung.mods.moreplanets.module.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.util.EnumParticleTypesMP;
import stevekung.mods.moreplanets.util.entity.ISpaceMob;

public class EntityAlienMiner
extends EntityMob
implements IEntityBreathable,
ISpaceMob {
    private static DataParameter<Integer> TARGET_ENTITY = EntityDataManager.func_187226_a(EntityAlienMiner.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityLivingBase targetedEntity;
    private int chargedTime;

    public EntityAlienMiner(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.25f);
        this.field_70178_ae = true;
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AILaserBeamAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityGuardian.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new AlienMinerTargetSelector(this)));
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_184206_a(DataParameter key) {
        super.func_184206_a(key);
        if (TARGET_ENTITY.equals((Object)key)) {
            this.chargedTime = 0;
            this.targetedEntity = null;
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TARGET_ENTITY, (Object)0);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() + 2.5f;
    }

    protected SoundEvent func_184639_G() {
        return MPSounds.ALIEN_MINER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MPSounds.ALIEN_MINER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MPSounds.ALIEN_MINER_DEATH;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (this.field_70170_p.field_72995_K && this.hasTargetedEntity()) {
            if (this.chargedTime < 80) {
                ++this.chargedTime;
            }
            MorePlanetsCore.PROXY.spawnParticle(EnumParticleTypesMP.ALIEN_MINER_SPARK, this.field_70165_t, this.field_70163_u + 0.85 + (double)this.getHoverTick(FMLClientHandler.instance().getClient().func_184121_ak()), this.field_70161_v, new Object[]{Float.valueOf(-this.getChargedTime(0.0f))});
            EntityLivingBase entitylivingbase = this.getTargetedEntity();
            if (entitylivingbase != null) {
                this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
                this.func_70671_ap().func_75649_a();
            }
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.hasTargetedEntity()) {
            this.field_70181_x += (0.1 - this.field_70181_x) * 0.1;
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public boolean func_70687_e(PotionEffect potion) {
        Potion potionEff = potion.func_188419_a();
        return potionEff != MobEffects.field_76436_u && potionEff != MobEffects.field_76433_i && potionEff != MobEffects.field_82731_v && potionEff != MPPotions.INFECTED_CRYSTALLIZE && potionEff != MPPotions.INFECTED_SPORE;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public float getChargedTime(float time) {
        return ((float)this.chargedTime + time) / 80.0f;
    }

    private void setTargetedEntity(int entityId) {
        this.field_70180_af.func_187227_b(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY) != 0;
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        return MPLootTables.ALIEN_MINER;
    }

    public boolean canBreath() {
        return true;
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.ROBOT;
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ENTITY)).intValue());
            if (entity instanceof EntityLivingBase) {
                this.targetedEntity = (EntityLivingBase)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @SideOnly(value=Side.CLIENT)
    public float getHoverTick(float partialTicks) {
        float partialTicksTime = (float)this.field_70173_aa + partialTicks;
        float hoverTime = MathHelper.func_76126_a((float)(partialTicksTime / 12.0f)) / 30.0f + 0.5f;
        hoverTime = hoverTime * hoverTime + hoverTime;
        return hoverTime;
    }

    static class AlienMinerTargetSelector
    implements Predicate<EntityLivingBase> {
        private EntityAlienMiner entity;

        public AlienMinerTargetSelector(EntityAlienMiner entity) {
            this.entity = entity;
        }

        public boolean apply(EntityLivingBase entity) {
            return !(entity instanceof EntityAlienMiner) && entity.func_70068_e((Entity)this.entity) > 5.0;
        }
    }

    static class AISplashBlood
    extends EntityAIWander {
        private EntityAlienMiner entity;
        private boolean findStone;

        public AISplashBlood(EntityAlienMiner entity) {
            super((EntityCreature)entity, 1.0, 10);
            this.entity = entity;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            BlockPos blockpos;
            IBlockState iblockstate;
            if (this.entity.func_70638_az() != null) {
                return false;
            }
            if (!this.entity.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.entity.func_70681_au();
            if (random.nextInt(1000) == 0 && (iblockstate = this.entity.field_70170_p.func_180495_p((blockpos = new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v)).func_177977_b())) == DionaBlocks.DIONA_BLOCK.func_176203_a(0)) {
                this.findStone = true;
                return true;
            }
            this.findStone = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.findStone ? false : super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.findStone) {
                super.func_75249_e();
            } else {
                World world = this.entity.field_70170_p;
                BlockPos blockpos = new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
                IBlockState iblockstate = world.func_180495_p(blockpos.func_177977_b());
                if (iblockstate == DionaBlocks.DIONA_BLOCK.func_176203_a(0)) {
                    world.func_180501_a(blockpos.func_177977_b(), DionaBlocks.ALIEN_MINER_BLOOD.func_176223_P(), 3);
                }
            }
        }
    }

    static class AILaserBeamAttack
    extends EntityAIBase {
        private EntityAlienMiner entity;
        private int tickCounter;

        public AILaserBeamAttack(EntityAlienMiner entity) {
            this.entity = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.entity.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.entity.func_70068_e((Entity)this.entity.func_70638_az()) > 5.0;
        }

        public void func_75249_e() {
            this.tickCounter = -10;
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 90.0f, 90.0f);
            this.entity.field_70160_al = true;
        }

        public void func_75251_c() {
            this.entity.setTargetedEntity(0);
            this.entity.func_70624_b(null);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.entity.func_70638_az();
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 90.0f, 90.0f);
            if (!this.entity.func_70685_l((Entity)entitylivingbase)) {
                this.entity.func_70624_b(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.entity.setTargetedEntity(this.entity.func_70638_az().func_145782_y());
                    this.entity.func_184185_a(MPSounds.ALIEN_MINER_CHARGED, 2.0f + this.entity.getChargedTime(0.0f), 0.8f);
                } else if (this.tickCounter >= 80) {
                    float f = 1.0f;
                    if (this.entity.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    entitylivingbase.func_70097_a(DamageSource.func_76354_b((Entity)this.entity, (Entity)this.entity), f);
                    entitylivingbase.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.entity), (float)this.entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.entity.func_184185_a(MPSounds.ALIEN_MINER_ATTACK, 1.0f + this.entity.getChargedTime(0.0f), 0.8f);
                    entitylivingbase.func_184185_a(MPSounds.ALIEN_MINER_SHOCK, 1.0f + this.entity.getChargedTime(0.0f), 1.0f);
                    this.entity.func_70624_b(null);
                    if (entitylivingbase instanceof EntityPlayer) {
                        MorePlanetsCore.PROXY.resetFloatingTick((EntityPlayer)entitylivingbase);
                    }
                }
                super.func_75246_d();
            }
        }
    }
}

