/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.dimension;

import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.init.MPDimensions;
import stevekung.mods.moreplanets.init.MPPlanets;
import stevekung.mods.moreplanets.module.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.module.planets.diona.client.sky.SkyProviderDiona;
import stevekung.mods.moreplanets.module.planets.diona.world.gen.BiomeProviderDiona;
import stevekung.mods.moreplanets.module.planets.diona.world.gen.ChunkProviderDiona;
import stevekung.mods.moreplanets.util.dimension.WorldProviderMP;

public class WorldProviderDiona
extends WorldProviderMP {
    public long getDayLength() {
        return 96000L;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 0.75f) {
            value = 0.75f;
        }
        return value * value * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * (float)Math.PI * 2.0f)) * 2.0f + 0.1f);
        if (value < 0.55f) {
            value = 0.55f;
        }
        if (value > 1.075f) {
            value = 1.075f;
        }
        value = 1.0f - value;
        return value * 0.8f;
    }

    public double getSolarEnergyMultiplier() {
        return 2.5;
    }

    public float getGravity() {
        return 0.065f;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 4;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public CelestialBody getCelestialBody() {
        return MPPlanets.DIONA;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return -0.5f;
        }
        return -1.75f;
    }

    @Override
    public int getDarkEnergyMultiplier(World world, BlockPos pos) {
        if (this.isDaytime()) {
            return 120 + pos.func_177956_o() * 2;
        }
        return 150 + pos.func_177956_o() * 4;
    }

    @Override
    protected void renderSky() {
        this.setSkyRenderer(new SkyProviderDiona((IGalacticraftWorldProvider)this));
    }

    @Override
    protected void renderCloud() {
        this.setCloudRenderer((IRenderHandler)new CloudRenderer());
    }

    @Override
    protected void renderWeather() {
    }

    @Override
    public void func_76572_b() {
        this.field_76578_c = new BiomeProviderDiona();
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkProviderDiona(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public DimensionType func_186058_p() {
        return MPDimensions.DIONA;
    }

    public List<Block> getSurfaceBlocks() {
        return Arrays.asList(DionaBlocks.DIONA_BLOCK);
    }
}

