/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.module.planets.diona.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.module.planets.diona.tileentity.TileEntityDarkEnergyGenerator;
import stevekung.mods.moreplanets.util.ItemDescription;
import stevekung.mods.moreplanets.util.blocks.BlockTileMP;
import stevekung.mods.moreplanets.util.blocks.EnumSortCategoryBlock;
import stevekung.mods.moreplanets.util.blocks.IBlockDescription;
import stevekung.mods.moreplanets.util.blocks.ISingleBlockRender;
import stevekung.mods.moreplanets.util.helper.BlockStateHelper;
import stevekung.mods.moreplanets.util.helper.ItemDescriptionHelper;

public class BlockDarkEnergyGenerator
extends BlockTileMP
implements IBlockDescription,
ISingleBlockRender {
    public BlockDarkEnergyGenerator(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(name);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.75, 0.9);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        float particlePosX = (float)pos.func_177958_n() + 0.5f;
        float particlePosY = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
        float particlePosZ = (float)pos.func_177952_p() + 0.5f;
        float particleSize0 = 0.52f;
        float particleSize1 = rand.nextFloat() * 0.4f - 0.25f;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            TileEntityDarkEnergyGenerator tileEntity = (TileEntityDarkEnergyGenerator)tile;
            if (!tileEntity.disabled && tileEntity.darkEnergyFuel > 0) {
                for (int i = 0; i < 16; ++i) {
                    if (tileEntity.facing == 90 || tileEntity.facing == -90) {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        continue;
                    }
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = EnumFacing.func_176731_b((int)angle).func_176734_d().func_176736_b();
        int direction = 0;
        if (change == 0) {
            direction = 90;
        }
        if (change == 1) {
            direction = 0;
        }
        if (change == 2) {
            direction = -90;
        }
        if (change == 3) {
            direction = -180;
        }
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)placer.func_174811_aO().func_176734_d()));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            TileEntityDarkEnergyGenerator energy = (TileEntityDarkEnergyGenerator)world.func_175625_s(pos);
            energy.setFacing(direction);
            if (itemStack.func_77942_o()) {
                NBTTagCompound nbt = itemStack.func_77978_p();
                energy.storage.setEnergyStored(nbt.func_74760_g("EnergyStored"));
                energy.darkEnergyFuel = nbt.func_74762_e("DarkEnergyFuel");
                energy.inventory = NonNullList.func_191197_a((int)energy.func_70302_i_(), (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)energy.inventory);
            }
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack heldStack) {
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            TileEntityDarkEnergyGenerator electric = (TileEntityDarkEnergyGenerator)tile;
            ItemStack itemStack = new ItemStack((Block)this);
            NBTTagCompound nbt = new NBTTagCompound();
            if (electric.getEnergyStoredGC() > 0.0f) {
                nbt.func_74776_a("EnergyStored", electric.getEnergyStoredGC());
            }
            if (electric.darkEnergyFuel > 0) {
                nbt.func_74768_a("DarkEnergyFuel", electric.darkEnergyFuel);
            }
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)electric.inventory);
            itemStack.func_77982_d(nbt);
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
        }
    }

    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int change = ((EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)).func_176746_e().func_176736_b();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDarkEnergyGenerator) {
            int direction = 0;
            if (change == 0) {
                direction = 90;
            }
            if (change == 1) {
                direction = 0;
            }
            if (change == 2) {
                direction = -90;
            }
            if (change == 3) {
                direction = -180;
            }
            TileEntityDarkEnergyGenerator energy = (TileEntityDarkEnergyGenerator)tile;
            energy.setFacing(direction);
        }
        world.func_180501_a(pos, this.func_176203_a(change), 3);
        return true;
    }

    public boolean onMachineActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)MorePlanetsCore.INSTANCE, -1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state)) {
            world.func_175713_t(pos);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDarkEnergyGenerator();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) & 0xC;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta % 4));
        return this.func_176223_P().func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateHelper.FACING_HORIZON});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)BlockStateHelper.FACING_HORIZON, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockStateHelper.FACING_HORIZON)));
    }

    @Override
    public EnumSortCategoryBlock getBlockCategory(int meta) {
        return EnumSortCategoryBlock.MACHINE_NON_BLOCK;
    }

    @Override
    public ItemDescription getDescription() {
        return (itemStack, list) -> list.addAll(ItemDescriptionHelper.getDescription(this.func_149739_a() + ".description"));
    }

    @Override
    public String getName() {
        return "dark_energy_generator";
    }
}

