/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.init.MPBiomes;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPPotions;
import stevekung.mods.moreplanets.module.planets.chalos.blocks.BlockCheeseDirt;
import stevekung.mods.moreplanets.module.planets.chalos.blocks.ChalosBlocks;
import stevekung.mods.moreplanets.module.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.module.planets.fronos.blocks.BlockFronosDirt;
import stevekung.mods.moreplanets.module.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.BlockInfectedDirt;
import stevekung.mods.moreplanets.module.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.module.planets.nibiru.items.NibiruItems;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.util.CachedEnumUtil;
import stevekung.mods.moreplanets.util.blocks.IFireBlock;

public class GeneralEventHandler {
    private static List<BreakBlockData> INFECTED_BLOCK_LIST = new ArrayList<BreakBlockData>();
    private static List<BreakBlockData> NON_INFECTED_BLOCK_LIST = new ArrayList<BreakBlockData>();

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("moreplanets")) {
            ConfigManagerMP.syncConfig(false);
        }
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Block block = Block.func_149634_a((Item)event.getItemStack().func_77973_b());
        if (block == ChalosBlocks.CHEESE_SPORE_FLOWER || block == NibiruBlocks.NIBIRU_SAPLING) {
            event.setBurnTime(100);
        }
    }

    @SubscribeEvent
    public void onCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        Block block = event.getState().func_177230_c();
        if (block == DionaBlocks.CRYSTALLIZE_WATER_FLUID_BLOCK || block == ChalosBlocks.CHEESE_OF_MILK_FLUID_BLOCK || block == NibiruBlocks.INFECTED_WATER_FLUID_BLOCK) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos firePos = event.getPos().func_177972_a(event.getFace());
        if (event.getWorld().func_180495_p(firePos).func_177230_c() instanceof IFireBlock) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_FIRE_EXTINGUISH, GCCoreUtil.getDimensionID((World)event.getWorld()), firePos));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        ItemStack heldItem = event.getItemStack();
        if (!heldItem.func_190926_b() && (heldItem.func_77973_b() instanceof ItemSpade || heldItem.func_77973_b().getToolClasses(heldItem) == Collections.singleton("shovel")) && event.getFace() != EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
            if (world.func_180495_p(pos).func_177230_c() == NibiruBlocks.INFECTED_GRASS) {
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_180501_a(pos, NibiruBlocks.NIBIRU_GRASS_PATH.func_176223_P(), 11);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                }
                player.func_184609_a(event.getHand());
            } else if (world.func_180495_p(pos).func_177230_c() == NibiruBlocks.GREEN_VEIN_GRASS) {
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    world.func_180501_a(pos, NibiruBlocks.NIBIRU_GRASS_PATH.func_176203_a(1), 11);
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                }
                player.func_184609_a(event.getHand());
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block = event.getState().func_177230_c();
        EntityPlayer player = event.getEntityPlayer();
        if (this.isShears(player) && (block == FronosBlocks.CANDY_CANE_1 || block == FronosBlocks.CANDY_CANE_2)) {
            event.setNewSpeed(7.5f);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int meta;
        Block block;
        IBlockState sourceState = event.getState();
        Block source = sourceState.func_177230_c();
        EntityPlayer player = event.getPlayer();
        if (source == NibiruBlocks.INFECTED_FARMLAND && event.getWorld().getBiomeForCoordsBody(event.getPos()) == MPBiomes.GREEN_VEIN || player == null) {
            return;
        }
        for (BreakBlockData data : NON_INFECTED_BLOCK_LIST) {
            block = data.getBlock();
            meta = data.getMeta();
            if (!(meta != -1 ? source == block && source.func_176201_c(sourceState) == meta : source == block)) continue;
            return;
        }
        for (BreakBlockData data : NON_INFECTED_BLOCK_LIST) {
            block = data.getBlock();
            meta = data.getMeta();
            boolean flag = false;
            if (meta != -1) {
                if (source == block && source.func_176201_c(sourceState) == meta) {
                    flag = true;
                }
            } else if (source == block) {
                flag = true;
            }
            if (!flag || player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) || player.field_71075_bZ.field_75098_d) continue;
            player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 60));
        }
        if (source.getRegistryName().toString().contains("moreplanets") && (source.func_149739_a().contains("infected") || source.func_149739_a().contains("nibiru") || source.func_149732_F().contains("infected")) && !player.func_70644_a(MPPotions.INFECTED_SPORE_PROTECTION) && !player.field_71075_bZ.field_75098_d) {
            player.func_70690_d(new PotionEffect(MPPotions.INFECTED_SPORE, 60));
        }
        if (this.isShears(player) && (source == FronosBlocks.CANDY_CANE_1 || source == FronosBlocks.CANDY_CANE_2)) {
            player.func_184607_cu().func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void onPickupItem(PlayerEvent.ItemPickupEvent event) {
        ItemStack itemStack = event.getOriginalEntity().func_92059_d();
        Item item = itemStack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block == ChalosBlocks.CHEESE_SPORE_STEM || block == NibiruBlocks.NIBIRU_LOG) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onCraftItem(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        if (block == ChalosBlocks.CHALOS_CRAFTING_TABLE || block == NibiruBlocks.NIBIRU_CRAFTING_TABLE) {
            // empty if block
        }
        if (item == NibiruItems.NIBIRU_STONE_PICKAXE) {
            // empty if block
        }
        if (block == NibiruBlocks.NIBIRU_FURNACE || block == NibiruBlocks.TERRASTONE_FURNACE) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        if (event.getResult() != Event.Result.DEFAULT || event.isCanceled()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a())) {
            if (block == ChalosBlocks.CHEESE_DIRT) {
                this.setFarmland(event, world, pos, state, (IProperty<?>)BlockCheeseDirt.VARIANT, (Object)BlockCheeseDirt.BlockType.CHEESE_COARSE_DIRT, ChalosBlocks.CHEESE_DIRT, ChalosBlocks.CHEESE_FARMLAND);
            } else if (block == ChalosBlocks.CHEESE_GRASS) {
                this.setFarmland(event, world, pos, ChalosBlocks.CHEESE_FARMLAND);
            } else if (block == NibiruBlocks.INFECTED_DIRT) {
                this.setFarmland(event, world, pos, state, (IProperty<?>)BlockInfectedDirt.VARIANT, (Object)BlockInfectedDirt.BlockType.INFECTED_COARSE_DIRT, NibiruBlocks.INFECTED_DIRT, NibiruBlocks.INFECTED_FARMLAND);
            } else if (block == NibiruBlocks.INFECTED_GRASS || block == NibiruBlocks.GREEN_VEIN_GRASS) {
                this.setFarmland(event, world, pos, NibiruBlocks.INFECTED_FARMLAND);
            } else if (block == FronosBlocks.FRONOS_GRASS) {
                this.setFarmland(event, world, pos, FronosBlocks.FRONOS_FARMLAND);
            } else if (block == FronosBlocks.FRONOS_DIRT) {
                this.setFarmland(event, world, pos, state, (IProperty<?>)BlockFronosDirt.VARIANT, (Object)BlockFronosDirt.BlockType.FRONOS_COARSE_DIRT, FronosBlocks.FRONOS_DIRT, FronosBlocks.FRONOS_FARMLAND);
            }
        }
    }

    private void setFarmland(UseHoeEvent event, World world, BlockPos pos, IBlockState state, IProperty<?> property, Object value, Block dirt, Block farmland) {
        if (state.func_177229_b(property) == value) {
            world.func_175656_a(pos, dirt.func_176223_P());
        } else {
            world.func_175656_a(pos, farmland.func_176223_P());
        }
        event.setResult(Event.Result.ALLOW);
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundType.field_185849_b.func_185844_d(), SoundCategory.BLOCKS, (SoundType.field_185849_b.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185849_b.func_185847_b() * 0.8f);
        for (EnumHand hand : CachedEnumUtil.valuesHandCached()) {
            event.getEntityPlayer().func_184609_a(hand);
        }
    }

    private void setFarmland(UseHoeEvent event, World world, BlockPos pos, Block farmland) {
        world.func_175656_a(pos, farmland.func_176223_P());
        event.setResult(Event.Result.ALLOW);
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundType.field_185849_b.func_185844_d(), SoundCategory.BLOCKS, (SoundType.field_185849_b.func_185843_a() + 1.0f) / 2.0f, SoundType.field_185849_b.func_185847_b() * 0.8f);
        for (EnumHand hand : CachedEnumUtil.valuesHandCached()) {
            event.getEntityPlayer().func_184609_a(hand);
        }
    }

    private boolean isShears(EntityPlayer player) {
        return player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() instanceof ItemShears;
    }

    static {
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_WOODEN_SLAB_1, 1));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_WOODEN_SLAB_1, 9));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_WOODEN_SLAB_1, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_WOODEN_SLAB_1, 10));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.DOUBLE_WOODEN_SLAB_1, 1));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.DOUBLE_WOODEN_SLAB_1, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_COBBLESTONE_SLAB_1, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_COBBLESTONE_SLAB_1, 10));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.DOUBLE_COBBLESTONE_SLAB_1, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_DUNGEON_BRICK_SLAB_1, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.HALF_DUNGEON_BRICK_SLAB_1, 10));
        INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)MPBlocks.DOUBLE_DUNGEON_BRICK_SLAB_1, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData(MPBlocks.COBBLESTONE_WALL, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData(MPBlocks.DUNGEON_BRICK_WALL, 2));
        INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.JUICER_EGG, -1));
        INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.OIL_ORE, -1));
        INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.SPORELILY, -1));
        INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_GRASS_PATH, 0));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.INFECTED_CRYSTALLIZE_PLANKS, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.INFECTED_CRYSTALLIZE_FENCE, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.LARGE_INFECTED_CRYSTALLIZE, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.INFECTED_CRYSTALLIZE_TORCH, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.INFECTED_CRYSTALLIZE_WEB, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.INFECTED_CRYSTALLIZE_PART, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(DionaBlocks.INFECTED_CRYSTALLIZE_SLIME_BLOCK, -1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_BOOKSHELF, 1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_TALL_GRASS, 2));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_CRAFTING_TABLE, 1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_LEAVES, 3));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_LEAVES, 7));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_LEAVES, 11));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_FENCE, 2));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_LOG, 3));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_LOG, 7));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_LOG, 11));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_PLANKS, 2));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_SAPLING, 3));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_DOUBLE_PLANT, 3));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_DOUBLE_PLANT, 8));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_FLOWER, 1));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_FLOWER, 7));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_BLOCK, 7));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)NibiruBlocks.HALF_INFECTED_STONE_BRICKS_SLAB, 3));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)NibiruBlocks.HALF_INFECTED_STONE_BRICKS_SLAB, 11));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData((Block)NibiruBlocks.DOUBLE_INFECTED_STONE_BRICKS_SLAB, 3));
        NON_INFECTED_BLOCK_LIST.add(new BreakBlockData(NibiruBlocks.NIBIRU_GRASS_PATH, 1));
    }

    private static class BreakBlockData {
        private Block block;
        private int meta;

        public BreakBlockData(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

